/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.rewrite;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.filter.factory.rewrite.RewriteFunction;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ModifyRequestBodyGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    private final List<HttpMessageReader<?>> messageReaders;

    public ModifyRequestBodyGatewayFilterFactory() {
        super(Config.class);
        this.messageReaders = HandlerStrategies.withDefaults().messageReaders();
    }

    public ModifyRequestBodyGatewayFilterFactory(List<HttpMessageReader<?>> messageReaders) {
        super(Config.class);
        this.messageReaders = messageReaders;
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                ParameterizedTypeReference inClass = config.getInClass();
                ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, ModifyRequestBodyGatewayFilterFactory.this.messageReaders);
                Mono modifiedBody = serverRequest.bodyToMono(inClass).flatMap(originalBody -> config.getRewriteFunction().apply(exchange, originalBody)).switchIfEmpty(Mono.defer(() -> (Mono)config.getRewriteFunction().apply(exchange, null)));
                BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)modifiedBody, (ParameterizedTypeReference)config.getOutClass());
                HttpHeaders headers = new HttpHeaders();
                headers.putAll((Map)exchange.getRequest().getHeaders());
                headers.remove((Object)"Content-Length");
                if (config.getContentType() != null) {
                    headers.set("Content-Type", config.getContentType());
                }
                CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, headers);
                return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                    ServerHttpRequestDecorator decorator = ModifyRequestBodyGatewayFilterFactory.this.decorate(exchange, headers, outputMessage);
                    return chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build());
                })).onErrorResume(throwable -> ModifyRequestBodyGatewayFilterFactory.this.release(exchange, outputMessage, (Throwable)throwable));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(ModifyRequestBodyGatewayFilterFactory.this).append("Content type", (Object)config.getContentType()).append("In class", (Object)config.getInClass()).append("Out class", (Object)config.getOutClass()).toString();
            }
        };
    }

    protected Mono<Void> release(ServerWebExchange exchange, CachedBodyOutputMessage outputMessage, Throwable throwable) {
        if (outputMessage.isCached()) {
            return outputMessage.getBody().map(DataBufferUtils::release).then(Mono.error((Throwable)throwable));
        }
        return Mono.error((Throwable)throwable);
    }

    ServerHttpRequestDecorator decorate(ServerWebExchange exchange, final HttpHeaders headers, final CachedBodyOutputMessage outputMessage) {
        return new ServerHttpRequestDecorator(exchange.getRequest()){

            public HttpHeaders getHeaders() {
                long contentLength = headers.getContentLength();
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.putAll((Map)headers);
                if (contentLength > 0L) {
                    httpHeaders.setContentLength(contentLength);
                } else {
                    httpHeaders.set("Transfer-Encoding", "chunked");
                }
                return httpHeaders;
            }

            public Flux<DataBuffer> getBody() {
                return outputMessage.getBody();
            }
        };
    }

    public static class Config {
        private ParameterizedTypeReference inClass;
        private ParameterizedTypeReference outClass;
        private String contentType;
        private RewriteFunction rewriteFunction;

        public ParameterizedTypeReference getInClass() {
            return this.inClass;
        }

        public Config setInClass(Class inClass) {
            return this.setInClass(ParameterizedTypeReference.forType((Type)inClass));
        }

        public Config setInClass(ParameterizedTypeReference inTypeReference) {
            this.inClass = inTypeReference;
            return this;
        }

        public ParameterizedTypeReference getOutClass() {
            return this.outClass;
        }

        public Config setOutClass(Class outClass) {
            return this.setOutClass(ParameterizedTypeReference.forType((Type)outClass));
        }

        public Config setOutClass(ParameterizedTypeReference outClass) {
            this.outClass = outClass;
            return this;
        }

        public RewriteFunction getRewriteFunction() {
            return this.rewriteFunction;
        }

        public Config setRewriteFunction(RewriteFunction rewriteFunction) {
            this.rewriteFunction = rewriteFunction;
            return this;
        }

        public <T, R> Config setRewriteFunction(Class<T> inClass, Class<R> outClass, RewriteFunction<T, R> rewriteFunction) {
            this.setInClass(inClass);
            this.setOutClass(outClass);
            this.setRewriteFunction(rewriteFunction);
            return this;
        }

        public <T, R> Config setRewriteFunction(ParameterizedTypeReference<T> inClass, ParameterizedTypeReference<R> outClass, RewriteFunction<T, R> rewriteFunction) {
            this.setInClass(inClass);
            this.setOutClass(outClass);
            this.setRewriteFunction(rewriteFunction);
            return this;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Config setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }
    }
}

