/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route.builder;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractChangeRequestUriGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddRequestHeadersIfNotPresentGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddRequestParameterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.CacheRequestBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.DedupeResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.FallbackHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.JsonToGrpcGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.MapRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.PrefixPathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.PreserveHostHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RedirectToGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveJsonAttributesResponseBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveRequestParameterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RemoveResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestHeaderSizeGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestHeaderToRequestUriGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestRateLimiterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RequestSizeGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RetryGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewriteLocationResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewritePathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewriteRequestParameterGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.RewriteResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SaveSessionGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SecureHeadersGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetPathGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetRequestHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetRequestHostHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetResponseHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SetStatusGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerFilterFactory;
import org.springframework.cloud.gateway.filter.factory.StripPrefixGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.TokenRelayGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.ModifyRequestBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.ModifyResponseBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.RewriteFunction;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.route.builder.UriSpec;
import org.springframework.core.Ordered;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.util.unit.DataSize;
import org.springframework.web.server.ServerWebExchange;
import reactor.retry.Repeat;
import reactor.retry.Retry;

public class GatewayFilterSpec
extends UriSpec {
    private static final Log log = LogFactory.getLog(GatewayFilterSpec.class);

    public GatewayFilterSpec(Route.AsyncBuilder routeBuilder, RouteLocatorBuilder.Builder builder) {
        super(routeBuilder, builder);
    }

    public GatewayFilterSpec filter(GatewayFilter gatewayFilter) {
        if (gatewayFilter instanceof Ordered) {
            this.routeBuilder.filter(gatewayFilter);
            return this;
        }
        return this.filter(gatewayFilter, 0);
    }

    public GatewayFilterSpec filter(GatewayFilter gatewayFilter, int order) {
        if (gatewayFilter instanceof Ordered) {
            this.routeBuilder.filter(gatewayFilter);
            log.warn((Object)("GatewayFilter already implements ordered " + gatewayFilter.getClass() + "ignoring order parameter: " + order));
            return this;
        }
        this.routeBuilder.filter(new OrderedGatewayFilter(gatewayFilter, order));
        return this;
    }

    public GatewayFilterSpec filters(GatewayFilter ... gatewayFilters) {
        List<GatewayFilter> filters = this.transformToOrderedFilters(Stream.of(gatewayFilters));
        this.routeBuilder.filters(filters);
        return this;
    }

    public List<GatewayFilter> transformToOrderedFilters(Stream<GatewayFilter> stream) {
        return stream.map(filter -> {
            if (filter instanceof Ordered) {
                return filter;
            }
            return new OrderedGatewayFilter((GatewayFilter)filter, 0);
        }).collect(Collectors.toList());
    }

    public GatewayFilterSpec filters(Collection<GatewayFilter> gatewayFilters) {
        List<GatewayFilter> filters = this.transformToOrderedFilters(gatewayFilters.stream());
        this.routeBuilder.filters(filters);
        return this;
    }

    public GatewayFilterSpec addRequestHeader(String headerName, String headerValue) {
        return this.filter(this.getBean(AddRequestHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName).setValue(headerValue)));
    }

    public GatewayFilterSpec addRequestHeadersIfNotPresent(String ... headers) {
        return this.filter(this.getBean(AddRequestHeadersIfNotPresentGatewayFilterFactory.class).apply(c -> {
            AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValue[] values = (AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValue[])Arrays.stream(headers).map(header -> header.split(":")).map(parts -> new AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValue(parts[0], parts[1])).toArray(AddRequestHeadersIfNotPresentGatewayFilterFactory.KeyValue[]::new);
            c.setKeyValues(values);
        }));
    }

    public GatewayFilterSpec addRequestParameter(String param, String value) {
        return this.filter(this.getBean(AddRequestParameterGatewayFilterFactory.class).apply(c -> c.setName(param).setValue(value)));
    }

    public GatewayFilterSpec addResponseHeader(String headerName, String headerValue) {
        return this.filter(this.getBean(AddResponseHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName).setValue(headerValue)));
    }

    public GatewayFilterSpec localResponseCache(Duration timeToLive, DataSize size) {
        return this.filter(this.getBean(LocalResponseCacheGatewayFilterFactory.class).apply(c -> c.setTimeToLive(timeToLive).setSize(size)));
    }

    public GatewayFilterSpec dedupeResponseHeader(String headerName, String strategy) {
        return this.filter(this.getBean(DedupeResponseHeaderGatewayFilterFactory.class).apply(c -> c.setStrategy(DedupeResponseHeaderGatewayFilterFactory.Strategy.valueOf(strategy)).setName(headerName)));
    }

    public GatewayFilterSpec circuitBreaker(Consumer<SpringCloudCircuitBreakerFilterFactory.Config> configConsumer) {
        SpringCloudCircuitBreakerFilterFactory filterFactory;
        try {
            filterFactory = this.getBean(SpringCloudCircuitBreakerFilterFactory.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new NoSuchBeanDefinitionException(SpringCloudCircuitBreakerFilterFactory.class, "There needs to be a circuit breaker implementation on the classpath that supports reactive APIs.");
        }
        return this.filter(filterFactory.apply(this.routeBuilder.getId(), configConsumer));
    }

    public GatewayFilterSpec jsonToGRPC(String protoDescriptor, String protoFile, String service, String method) {
        return this.filter(this.getBean(JsonToGrpcGatewayFilterFactory.class).apply(c -> c.setMethod(method).setProtoDescriptor(protoDescriptor).setProtoFile(protoFile).setService(service)));
    }

    public GatewayFilterSpec mapRequestHeader(String fromHeader, String toHeader) {
        return this.filter(this.getBean(MapRequestHeaderGatewayFilterFactory.class).apply(c -> c.setFromHeader(fromHeader).setToHeader(toHeader)));
    }

    public <T, R> GatewayFilterSpec modifyRequestBody(Class<T> inClass, Class<R> outClass, RewriteFunction<T, R> rewriteFunction) {
        return this.filter(this.getBean(ModifyRequestBodyGatewayFilterFactory.class).apply(c -> c.setRewriteFunction(inClass, outClass, rewriteFunction)));
    }

    public <T, R> GatewayFilterSpec modifyRequestBody(ParameterizedTypeReference<T> inClass, ParameterizedTypeReference<R> outClass, RewriteFunction<T, R> rewriteFunction) {
        return this.filter(this.getBean(ModifyRequestBodyGatewayFilterFactory.class).apply(c -> c.setRewriteFunction(inClass, outClass, rewriteFunction)));
    }

    public <T, R> GatewayFilterSpec modifyRequestBody(Class<T> inClass, Class<R> outClass, String newContentType, RewriteFunction<T, R> rewriteFunction) {
        return this.filter(this.getBean(ModifyRequestBodyGatewayFilterFactory.class).apply(c -> c.setRewriteFunction(inClass, outClass, rewriteFunction).setContentType(newContentType)));
    }

    public <T, R> GatewayFilterSpec modifyRequestBody(ParameterizedTypeReference<T> inClass, ParameterizedTypeReference<R> outClass, String newContentType, RewriteFunction<T, R> rewriteFunction) {
        return this.filter(this.getBean(ModifyRequestBodyGatewayFilterFactory.class).apply(c -> c.setRewriteFunction(inClass, outClass, rewriteFunction).setContentType(newContentType)));
    }

    public GatewayFilterSpec cacheRequestBody(Class<?> bodyClass) {
        return this.filter(this.getBean(CacheRequestBodyGatewayFilterFactory.class).apply(c -> c.setBodyClass(bodyClass)));
    }

    public <T, R> GatewayFilterSpec modifyRequestBody(Consumer<ModifyRequestBodyGatewayFilterFactory.Config> configConsumer) {
        return this.filter(this.getBean(ModifyRequestBodyGatewayFilterFactory.class).apply(configConsumer));
    }

    public <T, R> GatewayFilterSpec modifyResponseBody(Class<T> inClass, Class<R> outClass, RewriteFunction<T, R> rewriteFunction) {
        return this.filter(this.getBean(ModifyResponseBodyGatewayFilterFactory.class).apply(c -> c.setRewriteFunction(inClass, outClass, rewriteFunction)));
    }

    public <T, R> GatewayFilterSpec modifyResponseBody(Class<T> inClass, Class<R> outClass, String newContentType, RewriteFunction<T, R> rewriteFunction) {
        return this.filter(this.getBean(ModifyResponseBodyGatewayFilterFactory.class).apply(c -> c.setRewriteFunction(inClass, outClass, rewriteFunction).setNewContentType(newContentType)));
    }

    public <T, R> GatewayFilterSpec modifyResponseBody(Consumer<ModifyResponseBodyGatewayFilterFactory.Config> configConsumer) {
        return this.filter(this.getBean(ModifyResponseBodyGatewayFilterFactory.class).apply(configConsumer));
    }

    public GatewayFilterSpec prefixPath(String prefix) {
        return this.filter(this.getBean(PrefixPathGatewayFilterFactory.class).apply(c -> c.setPrefix(prefix)));
    }

    public GatewayFilterSpec preserveHostHeader() {
        return this.filter(this.getBean(PreserveHostHeaderGatewayFilterFactory.class).apply());
    }

    public GatewayFilterSpec setHostHeader(String hostName) {
        return this.filter(this.getBean(SetRequestHostHeaderGatewayFilterFactory.class).apply(c -> c.setHost(hostName)));
    }

    public GatewayFilterSpec redirect(int status, URI url) {
        return this.redirect(String.valueOf(status), url.toString());
    }

    public GatewayFilterSpec redirect(int status, URI url, boolean includeRequestParams) {
        return this.redirect(String.valueOf(status), url.toString(), includeRequestParams);
    }

    public GatewayFilterSpec redirect(int status, String url) {
        return this.redirect(String.valueOf(status), url);
    }

    public GatewayFilterSpec redirect(int status, String url, boolean includeRequestParams) {
        return this.redirect(String.valueOf(status), url, includeRequestParams);
    }

    public GatewayFilterSpec redirect(String status, URI url) {
        return this.redirect(status, url.toString(), false);
    }

    public GatewayFilterSpec redirect(String status, String url, boolean includeRequestParams) {
        return this.filter(this.getBean(RedirectToGatewayFilterFactory.class).apply(status, url, includeRequestParams));
    }

    public GatewayFilterSpec redirect(String status, String url) {
        return this.filter(this.getBean(RedirectToGatewayFilterFactory.class).apply(status, url));
    }

    public GatewayFilterSpec redirect(HttpStatus status, URL url) {
        return this.redirect(status, url, false);
    }

    public GatewayFilterSpec redirect(HttpStatus status, URL url, boolean includeRequestParams) {
        try {
            return this.filter(this.getBean(RedirectToGatewayFilterFactory.class).apply(status, url.toURI(), includeRequestParams));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
    }

    public GatewayFilterSpec removeJsonAttributes(String ... attributes) {
        return this.removeJsonAttributes(false, attributes);
    }

    public GatewayFilterSpec removeJsonAttributes(boolean deleteRecursively, String ... attributes) {
        return this.filter(this.getBean(RemoveJsonAttributesResponseBodyGatewayFilterFactory.class).apply(c -> c.setFieldList(Arrays.asList(attributes)).setDeleteRecursively(deleteRecursively)));
    }

    public GatewayFilterSpec removeRequestHeader(String headerName) {
        return this.filter(this.getBean(RemoveRequestHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName)));
    }

    public GatewayFilterSpec removeRequestParameter(String paramName) {
        return this.filter(this.getBean(RemoveRequestParameterGatewayFilterFactory.class).apply(c -> c.setName(paramName)));
    }

    public GatewayFilterSpec removeResponseHeader(String headerName) {
        return this.filter(this.getBean(RemoveResponseHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName)));
    }

    public GatewayFilterSpec requestRateLimiter(Consumer<RequestRateLimiterGatewayFilterFactory.Config> configConsumer) {
        return this.filter(this.getBean(RequestRateLimiterGatewayFilterFactory.class).apply(this.routeBuilder.getId(), configConsumer));
    }

    public RequestRateLimiterSpec requestRateLimiter() {
        return new RequestRateLimiterSpec(this.getBean(RequestRateLimiterGatewayFilterFactory.class));
    }

    public GatewayFilterSpec rewritePath(String regex, String replacement) {
        return this.filter(this.getBean(RewritePathGatewayFilterFactory.class).apply(c -> c.setRegexp(regex).setReplacement(replacement)));
    }

    public GatewayFilterSpec retry(int retries) {
        return this.filter(this.getBean(RetryGatewayFilterFactory.class).apply(this.routeBuilder.getId(), retryConfig -> retryConfig.setRetries(retries)));
    }

    public GatewayFilterSpec retry(Consumer<RetryGatewayFilterFactory.RetryConfig> retryConsumer) {
        return this.filter(this.getBean(RetryGatewayFilterFactory.class).apply(this.routeBuilder.getId(), retryConsumer));
    }

    public GatewayFilterSpec retry(Repeat<ServerWebExchange> repeat, Retry<ServerWebExchange> retry) {
        RetryGatewayFilterFactory filterFactory = this.getBean(RetryGatewayFilterFactory.class);
        return this.filter(filterFactory.apply(this.routeBuilder.getId(), repeat, retry));
    }

    public GatewayFilterSpec secureHeaders() {
        return this.filter(this.getBean(SecureHeadersGatewayFilterFactory.class).apply(config -> {}));
    }

    public GatewayFilterSpec secureHeaders(Consumer<SecureHeadersGatewayFilterFactory.Config> configConsumer) {
        return this.filter(this.getBean(SecureHeadersGatewayFilterFactory.class).apply(configConsumer));
    }

    public GatewayFilterSpec setPath(String template) {
        return this.filter(this.getBean(SetPathGatewayFilterFactory.class).apply(c -> c.setTemplate(template)));
    }

    public GatewayFilterSpec setRequestHeader(String headerName, String headerValue) {
        return this.filter(this.getBean(SetRequestHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName).setValue(headerValue)));
    }

    public GatewayFilterSpec setResponseHeader(String headerName, String headerValue) {
        return this.filter(this.getBean(SetResponseHeaderGatewayFilterFactory.class).apply(c -> c.setName(headerName).setValue(headerValue)));
    }

    public GatewayFilterSpec rewriteResponseHeader(String headerName, String regex, String replacement) {
        return this.filter(this.getBean(RewriteResponseHeaderGatewayFilterFactory.class).apply(c -> c.setReplacement(replacement).setRegexp(regex).setName(headerName)));
    }

    public GatewayFilterSpec rewriteLocationResponseHeader(String stripVersionMode, String locationHeaderName, String hostValue, String protocolsRegex) {
        return this.filter(this.getBean(RewriteLocationResponseHeaderGatewayFilterFactory.class).apply(c -> c.setStripVersion(RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.valueOf(stripVersionMode)).setLocationHeaderName(locationHeaderName).setHostValue(hostValue).setProtocols(protocolsRegex)));
    }

    public GatewayFilterSpec rewriteRequestParameter(String name, String replacement) {
        return this.filter(this.getBean(RewriteRequestParameterGatewayFilterFactory.class).apply(c -> c.setReplacement(replacement).setName(name)));
    }

    public GatewayFilterSpec setStatus(int status) {
        return this.setStatus(String.valueOf(status));
    }

    public GatewayFilterSpec setStatus(HttpStatus status) {
        return this.setStatus(status.name());
    }

    public GatewayFilterSpec setStatus(String status) {
        return this.filter(this.getBean(SetStatusGatewayFilterFactory.class).apply(c -> c.setStatus(status)));
    }

    public GatewayFilterSpec saveSession() {
        return this.filter(this.getBean(SaveSessionGatewayFilterFactory.class).apply(c -> {}));
    }

    public GatewayFilterSpec stripPrefix(int parts) {
        return this.filter(this.getBean(StripPrefixGatewayFilterFactory.class).apply(c -> c.setParts(parts)));
    }

    public GatewayFilterSpec requestHeaderToRequestUri(String headerName) {
        return this.filter(((AbstractChangeRequestUriGatewayFilterFactory)this.getBean(RequestHeaderToRequestUriGatewayFilterFactory.class)).apply(c -> c.setName(headerName)));
    }

    public GatewayFilterSpec changeRequestUri(final Function<ServerWebExchange, Optional<URI>> determineRequestUri) {
        return this.filter(new AbstractChangeRequestUriGatewayFilterFactory<Object>(Object.class){

            @Override
            protected Optional<URI> determineRequestUri(ServerWebExchange exchange, Object config) {
                return (Optional)determineRequestUri.apply(exchange);
            }
        }.apply(c -> {}));
    }

    public GatewayFilterSpec setRequestSize(Long size) {
        return this.setRequestSize(DataSize.ofBytes((long)size));
    }

    public GatewayFilterSpec setRequestSize(DataSize size) {
        return this.filter(this.getBean(RequestSizeGatewayFilterFactory.class).apply(c -> c.setMaxSize(size)));
    }

    public GatewayFilterSpec setRequestHeaderSize(DataSize size) {
        return this.filter(this.getBean(RequestHeaderSizeGatewayFilterFactory.class).apply(c -> c.setMaxSize(size)));
    }

    public GatewayFilterSpec tokenRelay() {
        try {
            return this.filter(this.getBean(TokenRelayGatewayFilterFactory.class).apply(c -> {}));
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalStateException("No TokenRelayGatewayFilterFactory bean was found. Did you include the org.springframework.boot:spring-boot-starter-oauth2-client dependency?");
        }
    }

    public GatewayFilterSpec tokenRelay(String clientRegistrationId) {
        try {
            return this.filter(this.getBean(TokenRelayGatewayFilterFactory.class).apply(c -> c.setName(clientRegistrationId)));
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new IllegalStateException("No TokenRelayGatewayFilterFactory bean was found. Did you include the org.springframework.boot:spring-boot-starter-oauth2-client dependency?");
        }
    }

    public GatewayFilterSpec fallbackHeaders(FallbackHeadersGatewayFilterFactory.Config config) {
        FallbackHeadersGatewayFilterFactory factory = this.getFallbackHeadersGatewayFilterFactory();
        return this.filter(factory.apply(config));
    }

    public GatewayFilterSpec fallbackHeaders(Consumer<FallbackHeadersGatewayFilterFactory.Config> configConsumer) {
        FallbackHeadersGatewayFilterFactory factory = this.getFallbackHeadersGatewayFilterFactory();
        return this.filter(factory.apply(configConsumer));
    }

    private FallbackHeadersGatewayFilterFactory getFallbackHeadersGatewayFilterFactory() {
        FallbackHeadersGatewayFilterFactory factory;
        try {
            factory = this.getBean(FallbackHeadersGatewayFilterFactory.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new NoSuchBeanDefinitionException(FallbackHeadersGatewayFilterFactory.class, "This is probably because Hystrix is missing from the classpath, which can be resolved by adding dependency on 'org.springframework.cloud:spring-cloud-starter-netflix-hystrix'");
        }
        return factory;
    }

    public class RequestRateLimiterSpec {
        private final RequestRateLimiterGatewayFilterFactory filter;

        public RequestRateLimiterSpec(RequestRateLimiterGatewayFilterFactory filter) {
            this.filter = filter;
        }

        public <C, R extends RateLimiter<C>> RequestRateLimiterSpec rateLimiter(Class<R> rateLimiterType, Consumer<C> configConsumer) {
            RateLimiter rateLimiter = (RateLimiter)GatewayFilterSpec.this.getBean(rateLimiterType);
            Object config = rateLimiter.newConfig();
            configConsumer.accept(config);
            rateLimiter.getConfig().put(GatewayFilterSpec.this.routeBuilder.getId(), config);
            return this;
        }

        public GatewayFilterSpec configure(Consumer<RequestRateLimiterGatewayFilterFactory.Config> configConsumer) {
            GatewayFilterSpec.this.filter(this.filter.apply(GatewayFilterSpec.this.routeBuilder.getId(), configConsumer));
            return GatewayFilterSpec.this;
        }

        public GatewayFilterSpec and() {
            return this.configure(config -> {});
        }
    }
}

