/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DedupeResponseHeaderGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String STRATEGY_KEY = "strategy";

    public DedupeResponseHeaderGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name", STRATEGY_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return chain.filter(exchange).then(Mono.fromRunnable(() -> DedupeResponseHeaderGatewayFilterFactory.this.dedupe(exchange.getResponse().getHeaders(), config)));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(DedupeResponseHeaderGatewayFilterFactory.this).append(config.getName(), (Object)config.getStrategy()).toString();
            }
        };
    }

    void dedupe(HttpHeaders headers, Config config) {
        String names = config.getName();
        Strategy strategy = config.getStrategy();
        if (headers == null || names == null || strategy == null) {
            return;
        }
        for (String name : names.split(" ")) {
            this.dedupe(headers, name.trim(), strategy);
        }
    }

    private void dedupe(HttpHeaders headers, String name, Strategy strategy) {
        List values = headers.get((Object)name);
        if (values == null || values.size() <= 1) {
            return;
        }
        switch (strategy) {
            case RETAIN_FIRST: {
                headers.set(name, (String)values.get(0));
                break;
            }
            case RETAIN_LAST: {
                headers.set(name, (String)values.get(values.size() - 1));
                break;
            }
            case RETAIN_UNIQUE: {
                headers.put(name, new ArrayList(new LinkedHashSet(values)));
                break;
            }
        }
    }

    public static class Config
    extends AbstractGatewayFilterFactory.NameConfig {
        private Strategy strategy = Strategy.RETAIN_FIRST;

        public Strategy getStrategy() {
            return this.strategy;
        }

        public Config setStrategy(Strategy strategy) {
            this.strategy = strategy;
            return this;
        }
    }

    public static enum Strategy {
        RETAIN_FIRST,
        RETAIN_LAST,
        RETAIN_UNIQUE;

    }
}

