/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.actuate;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Maps;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.server.ServerWebExchange;

@SpringBootTest(properties={"management.endpoint.gateway.enabled=true", "management.endpoints.web.exposure.include=*", "spring.cloud.gateway.actuator.verbose.enabled=true"}, webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public class GatewayControllerEndpointTests {
    @Autowired
    WebTestClient testClient;
    @LocalServerPort
    int port;

    @Test
    public void testEndpoints() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            Assertions.assertThat((List)responseBody).isNotEmpty();
            Assertions.assertThat((List)responseBody).contains((Object[])new Map[]{Map.of("href", "/actuator/gateway/", "methods", List.of("GET")), Map.of("href", "/actuator/gateway/globalfilters", "methods", List.of("GET")), Map.of("href", "/actuator/gateway/refresh", "methods", List.of("POST")), Map.of("href", "/actuator/gateway/routedefinitions", "methods", List.of("GET")), Map.of("href", "/actuator/gateway/routefilters", "methods", List.of("GET")), Map.of("href", "/actuator/gateway/routepredicates", "methods", List.of("GET")), Map.of("href", "/actuator/gateway/routes", "methods", List.of("POST", "GET")), Map.of("href", "/actuator/gateway/routes/test-service", "methods", List.of("POST", "DELETE", "GET")), Map.of("href", "/actuator/gateway/routes/route_with_metadata", "methods", List.of("POST", "DELETE", "GET"))});
        });
    }

    @Test
    public void testRefresh() {
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh", new Object[0])).exchange().expectStatus().isOk();
    }

    @Test
    public void testRoutes() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            Assertions.assertThat((List)responseBody).isNotEmpty();
        });
    }

    @Test
    public void testGetSpecificRoute() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-service", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            Assertions.assertThat((List)responseBody).isNotNull();
            Assertions.assertThat((int)responseBody.size()).isEqualTo(1);
            Assertions.assertThat((List)responseBody).isNotEmpty();
        });
    }

    @Test
    public void testRouteReturnsMetadata() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes/route_with_metadata", new Object[0]).exchange().expectStatus().isOk().expectBody().jsonPath("$.metadata").value(map -> ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)((Map)map)).hasSize(3)).containsEntry((Object)"optionName", (Object)"OptionValue")).containsEntry((Object)"iAmNumber", (Object)1)).containsEntry((Object)"compositeObject", (Object)Maps.newHashMap((Object)"name", (Object)"value")));
    }

    @Test
    public void testRouteFilters() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routefilters", new Object[0]).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map responseBody = (Map)result.getResponseBody();
            Assertions.assertThat((Map)responseBody).isNotEmpty();
        });
    }

    @Test
    public void testRoutePredicates() {
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routepredicates", new Object[0]).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map responseBody = (Map)result.getResponseBody();
            Assertions.assertThat((Map)responseBody).isNotEmpty();
        });
    }

    @Test
    public void testRouteDelete() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        PredicateDefinition methodRoutePredicateDefinition = new PredicateDefinition("Method=GET");
        testRouteDefinition.setPredicates(Arrays.asList(methodRoutePredicateDefinition));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-route-to-be-delete", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isCreated();
        this.testClient.delete().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-route-to-be-delete", new Object[0]).exchange().expectStatus().isOk().expectBody(ResponseEntity.class).consumeWith(result -> {
            HttpStatusCode httpStatus = result.getStatus();
            org.junit.jupiter.api.Assertions.assertEquals((Object)HttpStatus.OK, (Object)httpStatus);
        });
    }

    @Test
    public void testPostValidRouteDefinition() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        FilterDefinition prefixPathFilterDefinition = new FilterDefinition("PrefixPath=/test-path");
        FilterDefinition redirectToFilterDefinition = new FilterDefinition("RemoveResponseHeader=Sensitive-Header");
        FilterDefinition testFilterDefinition = new FilterDefinition("TestFilter");
        testRouteDefinition.setFilters(Arrays.asList(prefixPathFilterDefinition, redirectToFilterDefinition, testFilterDefinition));
        PredicateDefinition hostRoutePredicateDefinition = new PredicateDefinition("Host=myhost.org");
        PredicateDefinition methodRoutePredicateDefinition = new PredicateDefinition("Method=GET");
        PredicateDefinition testPredicateDefinition = new PredicateDefinition("Test=value");
        testRouteDefinition.setPredicates(Arrays.asList(hostRoutePredicateDefinition, methodRoutePredicateDefinition, testPredicateDefinition));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-route", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isCreated();
    }

    @Test
    public void testRefreshByGroup() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        String group1 = "group-1_" + UUID.randomUUID();
        testRouteDefinition.setMetadata(Map.of("groupBy", group1));
        String routeId1 = "route-1_" + UUID.randomUUID();
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId1, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isCreated();
        RouteDefinition testRouteDefinition2 = new RouteDefinition();
        testRouteDefinition2.setUri(URI.create("http://example.org"));
        String group2 = "group-2_" + UUID.randomUUID();
        testRouteDefinition2.setMetadata(Map.of("groupBy", group2));
        String routeId2 = "route-2_" + UUID.randomUUID();
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId2, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition2)).exchange().expectStatus().isCreated();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh?metadata=groupBy:" + group1, new Object[0])).exchange().expectStatus().isOk();
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            ((AbstractListAssert)Assertions.assertThat((List)responseBody).extracting("route_id").contains(new Object[]{routeId1})).doesNotContain(new Object[]{routeId2});
        });
    }

    @Test
    public void testOrderOfRefreshByGroup() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        testRouteDefinition.setOrder(1000);
        String group1 = "group-1_" + UUID.randomUUID();
        testRouteDefinition.setMetadata(Map.of("groupBy", group1));
        String routeId1 = "route-1_" + UUID.randomUUID();
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId1, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isCreated();
        RouteDefinition testRouteDefinition2 = new RouteDefinition();
        testRouteDefinition2.setUri(URI.create("http://example.org"));
        testRouteDefinition2.setOrder(0);
        String group2 = "group-2_" + UUID.randomUUID();
        testRouteDefinition2.setMetadata(Map.of("groupBy", group2));
        String routeId2 = "route-2_" + UUID.randomUUID();
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId2, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition2)).exchange().expectStatus().isCreated();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh?metadata=groupBy:" + group1, new Object[0])).exchange().expectStatus().isOk();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh?metadata=groupBy:" + group2, new Object[0])).exchange().expectStatus().isOk();
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            List ids = responseBody.stream().map(route -> route.get("route_id")).filter(id -> id.equals(routeId1) || id.equals(routeId2)).collect(Collectors.toList());
            Assertions.assertThat(ids).containsExactly(new Object[]{routeId2, routeId1});
        });
        testRouteDefinition2.setOrder(testRouteDefinition.getOrder() + 1);
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId2, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition2)).exchange().expectStatus().isCreated();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh?metadata=groupBy:" + group2, new Object[0])).exchange().expectStatus().isOk();
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            List ids = responseBody.stream().map(route -> route.get("route_id")).filter(id -> id.equals(routeId1) || id.equals(routeId2)).collect(Collectors.toList());
            Assertions.assertThat(ids).containsExactly(new Object[]{routeId1, routeId2});
        });
    }

    @Test
    public void testRefreshByGroup_whenRouteDefinitionsAreDeleted() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        String group1 = "group-1_" + UUID.randomUUID();
        testRouteDefinition.setMetadata(Map.of("groupBy", group1));
        String routeId1 = "route-1_" + UUID.randomUUID();
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId1, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isCreated();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh?metadata=groupBy:" + group1, new Object[0])).exchange().expectStatus().isOk();
        this.testClient.delete().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId1, new Object[0]).exchange().expectStatus().isOk();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh?metadata=groupBy:" + group1, new Object[0])).exchange().expectStatus().isOk();
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            Assertions.assertThat((List)responseBody).extracting("route_id").doesNotContain(new Object[]{routeId1});
        });
    }

    @Test
    public void testRefreshByGroupWithOneWrongFilterInSameGroup() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://wrong.route"));
        String group1 = "group-1_" + UUID.randomUUID();
        testRouteDefinition.setMetadata(Map.of("groupBy", group1));
        testRouteDefinition.setFilters(List.of(new FilterDefinition("StripPrefix=wrong")));
        String routeId1 = UUID.randomUUID().toString();
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId1, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isCreated();
        RouteDefinition testRouteDefinition2 = new RouteDefinition();
        testRouteDefinition2.setUri(URI.create("http://valid.route"));
        testRouteDefinition2.setMetadata(Map.of("groupBy", group1));
        String routeId2 = UUID.randomUUID().toString();
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId2, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition2)).exchange().expectStatus().isCreated();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh?metadata=groupBy:" + group1, new Object[0])).exchange().expectStatus().isOk();
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            Assertions.assertThat((List)responseBody).extracting("route_id").doesNotContain(new Object[]{routeId1, routeId2});
        });
    }

    @Test
    public void testRefreshByGroupDoesntImpactOthers() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        String routeId1 = UUID.randomUUID().toString();
        testRouteDefinition.setId(routeId1);
        testRouteDefinition.setUri(URI.create("http://wrong-group-1.route"));
        String group1 = "group-1_" + UUID.randomUUID();
        testRouteDefinition.setMetadata(Map.of("groupBy", group1));
        testRouteDefinition.setFilters(List.of(new FilterDefinition("StripPrefix=wrong")));
        RouteDefinition testRouteDefinition2 = new RouteDefinition();
        String routeId2 = UUID.randomUUID().toString();
        testRouteDefinition2.setId(routeId2);
        testRouteDefinition2.setUri(URI.create("http://valid-group-1.route"));
        testRouteDefinition2.setMetadata(Map.of("groupBy", group1));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId1, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isCreated();
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId2, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition2)).exchange().expectStatus().isCreated();
        RouteDefinition testRouteDefinition3 = new RouteDefinition();
        String routeId3 = UUID.randomUUID().toString();
        testRouteDefinition3.setId(routeId3);
        testRouteDefinition3.setUri(URI.create("http://valid-group-2.route"));
        String group2 = "group-2_" + UUID.randomUUID();
        testRouteDefinition3.setMetadata(Map.of("groupBy", group2));
        RouteDefinition testRouteDefinition4 = new RouteDefinition();
        String routeId4 = UUID.randomUUID().toString();
        testRouteDefinition4.setId(routeId4);
        testRouteDefinition4.setUri(URI.create("http://valid-group-2.route"));
        testRouteDefinition4.setMetadata(Map.of("groupBy", group2));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId3, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition3)).exchange().expectStatus().isCreated();
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/" + routeId4, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition4)).exchange().expectStatus().isCreated();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh?metadata=groupBy:" + group1, new Object[0])).exchange().expectStatus().isOk();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh?metadata=groupBy:" + group2, new Object[0])).exchange().expectStatus().isOk();
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routes", new Object[0]).exchange().expectStatus().isOk().expectBodyList(Map.class).consumeWith(result -> {
            List responseBody = (List)result.getResponseBody();
            ((AbstractListAssert)Assertions.assertThat((List)responseBody).extracting("route_id").doesNotContain(new Object[]{routeId1, routeId2})).contains(new Object[]{routeId3, routeId4});
        });
    }

    @Test
    public void testPostMultipleValidRouteDefinitions() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        String routeId1 = UUID.randomUUID().toString();
        testRouteDefinition.setId(routeId1);
        FilterDefinition prefixPathFilterDefinition = new FilterDefinition("PrefixPath=/test-path");
        FilterDefinition redirectToFilterDefinition = new FilterDefinition("RemoveResponseHeader=Sensitive-Header");
        FilterDefinition testFilterDefinition = new FilterDefinition("TestFilter");
        testRouteDefinition.setFilters(Arrays.asList(prefixPathFilterDefinition, redirectToFilterDefinition, testFilterDefinition));
        PredicateDefinition hostRoutePredicateDefinition = new PredicateDefinition("Host=myhost.org");
        PredicateDefinition methodRoutePredicateDefinition = new PredicateDefinition("Method=GET");
        PredicateDefinition testPredicateDefinition = new PredicateDefinition("Test=value");
        testRouteDefinition.setPredicates(Arrays.asList(hostRoutePredicateDefinition, methodRoutePredicateDefinition, testPredicateDefinition));
        RouteDefinition testRouteDefinition2 = new RouteDefinition();
        testRouteDefinition2.setUri(URI.create("http://example-2.org"));
        String routeId2 = UUID.randomUUID().toString();
        testRouteDefinition2.setId(routeId2);
        FilterDefinition prefixPathFilterDefinition2 = new FilterDefinition("PrefixPath=/test-path-2");
        FilterDefinition redirectToFilterDefinition2 = new FilterDefinition("RemoveResponseHeader=Sensitive-Header-2");
        FilterDefinition testFilterDefinition2 = new FilterDefinition("TestFilter");
        testRouteDefinition2.setFilters(Arrays.asList(prefixPathFilterDefinition2, redirectToFilterDefinition2, testFilterDefinition2));
        PredicateDefinition hostRoutePredicateDefinition2 = new PredicateDefinition("Host=myhost-2.org");
        PredicateDefinition methodRoutePredicateDefinition2 = new PredicateDefinition("Method=GET");
        PredicateDefinition testPredicateDefinition2 = new PredicateDefinition("Test=value-2");
        testRouteDefinition2.setPredicates(Arrays.asList(hostRoutePredicateDefinition2, methodRoutePredicateDefinition2, testPredicateDefinition2));
        List<RouteDefinition> multipleRouteDefs = List.of(testRouteDefinition, testRouteDefinition2);
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue(multipleRouteDefs)).exchange().expectStatus().isOk();
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routedefinitions", new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).exchange().expectBody().jsonPath("[?(@.id in ['%s','%s'])].id".formatted(routeId1, routeId2)).exists();
    }

    @Test
    public void testPostMultipleRoutesWithOneWrong_doesntPersistRouteDefinitions() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        String routeId1 = UUID.randomUUID().toString();
        testRouteDefinition.setId(routeId1);
        FilterDefinition prefixPathFilterDefinition = new FilterDefinition("PrefixPath=/test-path");
        FilterDefinition redirectToFilterDefinition = new FilterDefinition("RemoveResponseHeader=Sensitive-Header");
        FilterDefinition testFilterDefinition = new FilterDefinition("TestFilter");
        testRouteDefinition.setFilters(Arrays.asList(prefixPathFilterDefinition, redirectToFilterDefinition, testFilterDefinition));
        PredicateDefinition hostRoutePredicateDefinition = new PredicateDefinition("Host=myhost.org");
        PredicateDefinition methodRoutePredicateDefinition = new PredicateDefinition("Method=GET");
        PredicateDefinition testPredicateDefinition = new PredicateDefinition("Test=value");
        testRouteDefinition.setPredicates(Arrays.asList(hostRoutePredicateDefinition, methodRoutePredicateDefinition, testPredicateDefinition));
        RouteDefinition testRouteDefinition2 = new RouteDefinition();
        testRouteDefinition2.setUri(URI.create("this-is-wrong"));
        String routeId2 = UUID.randomUUID().toString();
        testRouteDefinition2.setId(routeId2);
        List<RouteDefinition> multipleRouteDefs = List.of(testRouteDefinition, testRouteDefinition2);
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue(multipleRouteDefs)).exchange().expectStatus().is4xxClientError();
        this.testClient.get().uri("http://localhost:" + this.port + "/actuator/gateway/routedefinitions", new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).exchange().expectBody().jsonPath("[?(@.id in ['%s','%s'])].id".formatted(routeId1, routeId2)).doesNotExist();
    }

    @Test
    public void testPostValidShortcutRouteDefinition() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setId("gatewaywithgrpcfiltertest-0-104014-8916263311295787431172436062-test-gateway-tls-client-mapping-0");
        testRouteDefinition.setUri(URI.create("https://localhost:8095"));
        testRouteDefinition.setOrder(0);
        testRouteDefinition.setMetadata(Collections.emptyMap());
        FilterDefinition longFilterDefinition = new FilterDefinition();
        FilterDefinition stripPrefix = new FilterDefinition();
        stripPrefix.setName("StripPrefix");
        stripPrefix.addArg("_genkey_0", "1");
        longFilterDefinition.setName("JsonToGrpc");
        longFilterDefinition.addArg("_genkey_0", "file:src/main/proto/hello.pb");
        longFilterDefinition.addArg("_genkey_1", "file:src/main/proto/hello.proto");
        longFilterDefinition.addArg("_genkey_2", "HelloService");
        longFilterDefinition.addArg("_genkey_3", "hello");
        testRouteDefinition.setFilters(Collections.singletonList(longFilterDefinition));
        PredicateDefinition hostRoutePredicateDefinition = new PredicateDefinition();
        hostRoutePredicateDefinition.setName("Path");
        hostRoutePredicateDefinition.addArg("_genkey_0", "/json/hello");
        testRouteDefinition.setPredicates(Arrays.asList(hostRoutePredicateDefinition));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-route", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isCreated();
    }

    @Test
    public void testPostRouteWithNotExistingFilter() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        FilterDefinition filterDefinition = new FilterDefinition("NotExistingFilter=test-config");
        testRouteDefinition.setFilters(Collections.singletonList(filterDefinition));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-route", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isBadRequest().expectBody().jsonPath("$.message").isEqualTo((Object)"Invalid FilterDefinition: [NotExistingFilter]");
    }

    @Test
    public void testPostRouteWithUriWithoutScheme() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("example.org"));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/no-scheme-test-route", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isBadRequest().expectBody().jsonPath("$.message").isEqualTo((Object)"The URI format [example.org] is incorrect, scheme can not be empty");
    }

    @Test
    public void testPostRouteWithUri() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(null);
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/no-scheme-test-route", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isBadRequest().expectBody().jsonPath("$.message").isEqualTo((Object)"The URI can not be empty");
    }

    @Test
    public void testPostRouteWithNotExistingPredicate() {
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setUri(URI.create("http://example.org"));
        PredicateDefinition predicateDefinition = new PredicateDefinition("NotExistingPredicate=test-config");
        testRouteDefinition.setPredicates(Collections.singletonList(predicateDefinition));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/test-route", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isBadRequest().expectBody().jsonPath("$.message").isEqualTo((Object)"Invalid PredicateDefinition: [NotExistingPredicate]");
    }

    private static class TestRoutePredicateFactory
    extends AbstractRoutePredicateFactory {
        TestRoutePredicateFactory(Class configClass) {
            super(configClass);
        }

        public Predicate<ServerWebExchange> apply(Object config) {
            return serverWebExchange -> true;
        }
    }

    private static class TestFilterGatewayFilterFactory
    extends AbstractGatewayFilterFactory {
        private TestFilterGatewayFilterFactory() {
        }

        public GatewayFilter apply(Object config) {
            return null;
        }
    }

    @SpringBootConfiguration
    @EnableAutoConfiguration
    @Import(value={PermitAllSecurityConfiguration.class})
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        RouteLocator testRouteLocator(RouteLocatorBuilder routeLocatorBuilder) {
            return routeLocatorBuilder.routes().route("test-service", r -> r.path(new String[]{"/test-service/**"}).uri("lb://test-service")).build();
        }

        @Bean
        public TestFilterGatewayFilterFactory customGatewayFilterFactory() {
            return new TestFilterGatewayFilterFactory();
        }

        @Bean
        public TestRoutePredicateFactory customGatewayPredicateFactory() {
            return new TestRoutePredicateFactory(Object.class);
        }
    }
}

