/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import org.junit.jupiter.api.Test;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cloud.gateway.config.LocalResponseCacheAutoConfiguration;
import org.springframework.cloud.gateway.filter.factory.cache.GlobalLocalResponseCacheGatewayFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

public class LocalResponseCacheAutoConfigurationTests {
    @Test
    void onlyOneCacheManagerBeanCreated() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{LocalResponseCacheAutoConfiguration.class}))).withPropertyValues(new String[]{"spring.cloud.gateway.filter.local-response-cache.enabled=true"})).run(context -> {
            context.containsBean("gatewayCacheManager");
            context.assertThat().hasSingleBean(GlobalLocalResponseCacheGatewayFilter.class);
        });
    }

    @Test
    void twoCacheManagerBeans() {
        ((ApplicationContextRunner)((ApplicationContextRunner)new ApplicationContextRunner().withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{CustomCacheManagerConfig.class, LocalResponseCacheAutoConfiguration.class}))).withPropertyValues(new String[]{"spring.cloud.gateway.filter.local-response-cache.enabled=true"})).run(context -> {
            context.containsBean("gatewayCacheManager");
            context.containsBean("myCacheManager");
            context.assertThat().hasSingleBean(GlobalLocalResponseCacheGatewayFilter.class);
        });
    }

    @Configuration(proxyBeanMethods=false)
    static class CustomCacheManagerConfig {
        CustomCacheManagerConfig() {
        }

        @Bean
        @Primary
        CacheManager myCacheManager() {
            return new CaffeineCacheManager();
        }

        @Bean
        Object myCacheConsumer(CacheManager cacheManager) {
            return "";
        }
    }
}

