/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"forwardstatic"})
public class ForwardRoutingFilterStaticIntegrationTests
extends BaseWebClientTests {
    @Test
    public void gatewayRequestsMeterFilterHasTags() {
        this.testClient.get().uri("/mydocs", new Object[0]).exchange().expectStatus().isOk().expectBody(String.class).consumeWith(result -> Assertions.assertThat((String)((String)result.getResponseBody())).contains(new CharSequence[]{"Docs 123"}));
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class CustomConfig {
    }
}

