/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import java.net.URI;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.springframework.boot.SpringBootVersion;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.RouteToRequestUrlFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpMethod;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RouteToRequestUrlFilterTests {
    @Test
    public void happyPath() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get?a=b", (Object[])new Object[0]).build();
        ServerWebExchange webExchange = this.testFilter(request, "http://myhost/mypath");
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("myhost").hasPath("/get").hasParameter("a", "b");
    }

    @Test
    public void happyPathLb() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/getb", (Object[])new Object[0]).build();
        ServerWebExchange webExchange = this.testFilter(request, "lb://myhost");
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("lb").hasHost("myhost");
    }

    @Test
    public void invalidHost() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/getb", (Object[])new Object[0]).build();
            this.testFilter(request, "lb://my_host");
        });
    }

    @Test
    public void happyPathLbPlusScheme() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/getb", (Object[])new Object[0]).build();
        ServerWebExchange webExchange = this.testFilter(request, "lb:http://myhost");
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("myhost");
        String schemePrefix = (String)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_SCHEME_PREFIX_ATTR);
        Assertions.assertThat((String)schemePrefix).isEqualTo("lb");
    }

    @Test
    public void noQueryParams() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]).build();
        ServerWebExchange webExchange = this.testFilter(request, "http://myhost");
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("myhost");
    }

    @Test
    public void encodedParameters() {
        URI url = UriComponentsBuilder.fromUriString((String)"http://localhost/get?a=b&c=d[]").buildAndExpand(new Object[0]).encode().toUri();
        Assertions.assertThat((String)url.getRawQuery()).isEqualTo("a=b&c=d%5B%5D");
        Assertions.assertThat((URI)url).hasParameter("c", "d[]");
        MockServerHttpRequest request = MockServerHttpRequest.method((HttpMethod)HttpMethod.GET, (URI)url).build();
        ServerWebExchange webExchange = this.testFilter(request, "http://myhost");
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("myhost").hasParameter("a", "b").hasParameter("c", "d[]");
        Assertions.assertThat((String)uri.getRawQuery()).isEqualTo("a=b&c=d%5B%5D");
    }

    @Test
    public void partialEncodedParameters() {
        Assume.assumeTrue((String)"partialEncodedParameters ignored for boot 2.2", (boolean)SpringBootVersion.getVersion().startsWith("2.3."));
        URI url = UriComponentsBuilder.fromUriString((String)"http://localhost/get?key[]=test= key&start=1533108081").build().toUri();
        Assertions.assertThat((String)url.getRawQuery()).isEqualTo("key[]=test=%20key&start=1533108081");
        Assertions.assertThat((URI)url).hasParameter("key[]", "test= key");
        Assertions.assertThat((URI)url).hasParameter("start", "1533108081");
        MockServerHttpRequest request = MockServerHttpRequest.method((HttpMethod)HttpMethod.GET, (URI)url).build();
        ServerWebExchange webExchange = this.testFilter(request, "http://myhost");
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("myhost").hasParameter("key[]", "test=%20key").hasParameter("start", "1533108081");
        Assertions.assertThat((String)uri.getRawQuery()).isEqualTo("key[]=test=%2520key&start=1533108081");
    }

    @Test
    public void encodedUrl() {
        URI url = UriComponentsBuilder.fromUriString((String)"http://localhost/abc def/get").buildAndExpand(new Object[0]).encode().toUri();
        Assertions.assertThat((String)url.getRawPath()).isEqualTo("/abc%20def/get");
        Assertions.assertThat((URI)url).hasPath("/abc def/get");
        MockServerHttpRequest request = MockServerHttpRequest.method((HttpMethod)HttpMethod.GET, (URI)url).build();
        ServerWebExchange webExchange = this.testFilter(request, "http://myhost/abc%20def/get");
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("myhost").hasPath("/abc def/get");
        Assertions.assertThat((String)uri.getRawPath()).isEqualTo("/abc%20def/get");
    }

    @Test
    public void unencodedParameters() {
        URI url = URI.create("http://localhost/get?a=b&c=d[]");
        Assertions.assertThat((String)url.getRawQuery()).isEqualTo("a=b&c=d[]");
        MockServerHttpRequest request = MockServerHttpRequest.method((HttpMethod)HttpMethod.GET, (URI)url).build();
        ServerWebExchange webExchange = this.testFilter(request, "http://myhost");
        URI uri = (URI)webExchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        Assertions.assertThat((URI)uri).hasScheme("http").hasHost("myhost").hasParameter("a", "b").hasParameter("c", "d[]");
        Assertions.assertThat((String)uri.getRawQuery()).isEqualTo("a=b&c=d[]");
    }

    @Test
    public void matcherWorks() {
        this.testMatcher(true, "lb:a123:stuff", "lb:abc:stuff", "lb:a.bc:stuff", "lb:a-bc:stuff", "lb:a+bc:stuff");
        this.testMatcher(false, "lb:a", "lb:a123", "lb:123:stuff", "lb:a//:stuff");
    }

    private void testMatcher(boolean shouldMatch, String ... uris) {
        for (String s : uris) {
            URI uri = URI.create(s);
            boolean result = RouteToRequestUrlFilter.hasAnotherScheme((URI)uri);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("%s should match: %s", new Object[]{s, result})).isEqualTo(shouldMatch);
        }
    }

    private ServerWebExchange testFilter(MockServerHttpRequest request, String routeUri) {
        Route value = ((Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("1")).uri(URI.create(routeUri))).order(0)).predicate(swe -> true).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, value);
        GatewayFilterChain filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)filterChain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        RouteToRequestUrlFilter filter = new RouteToRequestUrlFilter();
        filter.filter((ServerWebExchange)exchange, filterChain);
        return (ServerWebExchange)captor.getValue();
    }
}

