/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractNameValueGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AddRequestParameterGatewayFilterFactory;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.web.util.UriComponentsBuilder;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
@ActiveProfiles(profiles={"request-parameter-web-filter"})
public class AddRequestParameterGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void addRequestParameterFilterWorksBlankQuery() {
        this.testRequestParameterFilter(null, null);
    }

    @Test
    public void addRequestParameterFilterWorksNonBlankQuery() {
        this.testRequestParameterFilter("baz", "bam");
    }

    @Test
    public void addRequestParameterFilterWorksEncodedQuery() {
        this.testRequestParameterFilter("name", "%E6%89%8E%E6%A0%B9");
    }

    @Test
    public void addRequestParameterFilterWorksEncodedQueryJavaDsl() {
        this.testRequestParameterFilter("www.addreqparamjava.org", "ValueB-www", "javaname", "%E6%89%8E%E6%A0%B9");
    }

    @Test
    public void addRequestParameterFilterWorksEncodedPathSegmentJavaDsl() {
        this.testRequestParameterFilter("www.addreqparamjavaencodedsegment.org", "/anything/test%20", "ValueB-www", "javaname", "%E6%89%8E%E6%A0%B9");
    }

    private void testRequestParameterFilter(String name, String value) {
        this.testRequestParameterFilter("www.addrequestparameter.org", "ValueA", name, value);
    }

    private void testRequestParameterFilter(String host, String expectedValue, String name, String value) {
        this.testRequestParameterFilter(host, "/get", expectedValue, name, value);
    }

    private void testRequestParameterFilter(String host, String path, String expectedValue, String name, String value) {
        Object query = name != null ? "?" + name + "=" + value : "";
        URI uri = UriComponentsBuilder.fromUriString((String)(this.baseUri + path + (String)query)).build(true).toUri();
        boolean checkForEncodedValue = ServerWebExchangeUtils.containsEncodedParts((URI)uri);
        this.testClient.get().uri(uri).header("Host", new String[]{host}).exchange().expectBody(Map.class).consumeWith(response -> {
            Map<String, Object> args = TestUtils.getMap((Map)response.getResponseBody(), "args");
            Assertions.assertThat(args).containsEntry((Object)"example", (Object)expectedValue);
            if (name != null) {
                if (checkForEncodedValue) {
                    try {
                        Assertions.assertThat(args).containsEntry((Object)name, (Object)URLDecoder.decode(value, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    Assertions.assertThat(args).containsEntry((Object)name, (Object)value);
                }
            }
        });
    }

    @Test
    public void toStringFormat() {
        AbstractNameValueGatewayFilterFactory.NameValueConfig config = new AbstractNameValueGatewayFilterFactory.NameValueConfig().setName("myname").setValue("myvalue");
        GatewayFilter filter = new AddRequestParameterGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myname"})).contains(new CharSequence[]{"myvalue"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Value(value="${test.uri}")
        String uri;

        @Bean
        public RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("add_request_param_java_test", r -> r.path(new String[]{"/get"}).and().host(new String[]{"{sub}.addreqparamjava.org"}).filters(f -> f.prefixPath("/httpbin").addRequestParameter("example", "ValueB-{sub}")).uri(this.uri)).route("add_request_param_java_test_encoded_segment", r -> r.path(new String[]{"/anything/{segment}"}).and().host(new String[]{"{sub}.addreqparamjavaencodedsegment.org"}).filters(f -> f.prefixPath("/httpbin").addRequestParameter("example", "ValueB-{sub}")).uri(this.uri)).build();
        }
    }
}

