/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.RewriteLocationResponseHeaderGatewayFilterFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
public class RewriteLocationResponseHeaderGatewayFilterFactoryUnitTests {
    @InjectMocks
    private RewriteLocationResponseHeaderGatewayFilterFactory filter;
    @Mock
    private ServerWebExchange exchange;
    @Mock
    private ServerHttpRequest request;
    @Mock
    private ServerHttpResponse response;
    @Mock
    private HttpHeaders requestHeaders;
    @Mock
    private HttpHeaders responseHeaders;
    private URI uri;
    private RewriteLocationResponseHeaderGatewayFilterFactory.Config config;

    @BeforeEach
    public void setUp() {
        this.filter = new RewriteLocationResponseHeaderGatewayFilterFactory();
        Mockito.when((Object)this.exchange.getRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)this.exchange.getResponse()).thenReturn((Object)this.response);
        Mockito.when((Object)this.request.getHeaders()).thenReturn((Object)this.requestHeaders);
        Mockito.when((Object)this.response.getHeaders()).thenReturn((Object)this.responseHeaders);
        this.config = new RewriteLocationResponseHeaderGatewayFilterFactory.Config();
    }

    private void setupTest(String location, String host, String path) {
        Mockito.when((Object)this.responseHeaders.getFirst("Location")).thenReturn((Object)location);
        Mockito.when((Object)this.requestHeaders.getFirst("Host")).thenReturn((Object)host);
        this.uri = URI.create("http://" + host + path);
        Mockito.when((Object)this.request.getURI()).thenReturn((Object)this.uri);
    }

    @Test
    public void rewriteLocationNullLocation() {
        this.setupTest(null, "host", "/path");
        this.filter.rewriteLocation(this.exchange, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.responseHeaders, (VerificationMode)Mockito.never())).set(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void rewriteLocationNullHost() {
        this.setupTest("location", null, "/path");
        this.filter.rewriteLocation(this.exchange, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.responseHeaders, (VerificationMode)Mockito.never())).set(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void rewriteLocation() {
        this.setupTest("location", "host", "/path");
        this.filter.rewriteLocation(this.exchange, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.responseHeaders)).set((String)Mockito.eq((Object)"Location"), (String)Mockito.eq((Object)"location"));
    }

    @Test
    public void rewriteLocationCustomHeaderName() {
        this.setupTest("location", "host", "/path");
        Mockito.when((Object)this.responseHeaders.getFirst("Link")).thenReturn((Object)"link");
        this.config.setLocationHeaderName("Link");
        this.filter.rewriteLocation(this.exchange, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.responseHeaders)).set((String)Mockito.eq((Object)"Link"), (String)Mockito.eq((Object)"link"));
    }

    @Test
    public void rewriteLocationCustomHostValue() {
        this.setupTest("https://replaceme/some/path", "host", "/some/path");
        this.config.setHostValue("different.host");
        this.filter.rewriteLocation(this.exchange, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.responseHeaders)).set((String)Mockito.eq((Object)"Location"), (String)Mockito.eq((Object)"https://different.host/some/path"));
    }

    @Test
    public void rewriteLocationCustomProtocols() {
        this.setupTest("https://replaceme/some/path", "host", "/some/path");
        this.config.setProtocols("gopher|whatever");
        this.filter.rewriteLocation(this.exchange, this.config);
        ((HttpHeaders)Mockito.verify((Object)this.responseHeaders)).set((String)Mockito.eq((Object)"Location"), (String)Mockito.eq((Object)"https://replaceme/some/path"));
    }

    @Test
    public void fixedLocationVersionedAlwaysStrip() {
        String location = "https://backend-url.example.com:443/v1/path/to/riches";
        String host = "example.com:443";
        String path = "/v1/path/to/riches";
        this.setupTest(location, host, path);
        Assertions.assertThat((String)this.filter.fixedLocation(location, host, path, RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.ALWAYS_STRIP, this.config.getHostPortPattern(), this.config.getHostPortVersionPattern())).isEqualTo("https://example.com:443/path/to/riches");
    }

    @Test
    public void fixedLocationVersionedStripAsInRequest() {
        String location = "https://backend-url.example.com:443/v1/path/to/riches";
        String host = "example.com:443";
        String path = "/v1/path/to/riches";
        this.setupTest(location, host, path);
        Assertions.assertThat((String)this.filter.fixedLocation(location, host, path, RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.AS_IN_REQUEST, this.config.getHostPortPattern(), this.config.getHostPortVersionPattern())).isEqualTo("https://example.com:443/v1/path/to/riches");
    }

    @Test
    public void fixedLocationVersionedDontStrip() {
        String location = "https://backend-url.example.com:443/v1/path/to/riches";
        String host = "example.com:443";
        String path = "/v1/path/to/riches";
        this.setupTest(location, host, path);
        Assertions.assertThat((String)this.filter.fixedLocation(location, host, path, RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.NEVER_STRIP, this.config.getHostPortPattern(), this.config.getHostPortVersionPattern())).isEqualTo("https://example.com:443/v1/path/to/riches");
    }

    @Test
    public void fixedLocationUnversionedAlwaysStrip() {
        String location = "https://backend-url.example.com:443/v2/path/to/riches";
        String host = "api.example.com:443";
        String path = "/path/to/riches";
        this.setupTest(location, host, path);
        Assertions.assertThat((String)this.filter.fixedLocation(location, host, path, RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.ALWAYS_STRIP, this.config.getHostPortPattern(), this.config.getHostPortVersionPattern())).isEqualTo("https://api.example.com:443/path/to/riches");
    }

    @Test
    public void fixedLocationUnversionedStripAsInRequest() {
        String location = "https://backend-url.example.com:443/v2/path/to/riches";
        String host = "api.example.com:443";
        String path = "/path/to/riches";
        this.setupTest(location, host, path);
        Assertions.assertThat((String)this.filter.fixedLocation(location, host, path, RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.AS_IN_REQUEST, this.config.getHostPortPattern(), this.config.getHostPortVersionPattern())).isEqualTo("https://api.example.com:443/path/to/riches");
    }

    @Test
    public void fixedLocationUnversionedDontStrip() {
        String location = "https://backend-url.example.com:443/v2/path/to/riches";
        String host = "api.example.com:443";
        String path = "/path/to/riches";
        this.setupTest(location, host, path);
        Assertions.assertThat((String)this.filter.fixedLocation(location, host, path, RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.NEVER_STRIP, this.config.getHostPortPattern(), this.config.getHostPortVersionPattern())).isEqualTo("https://api.example.com:443/v2/path/to/riches");
    }

    @Test
    public void fixedLocationNoPort() {
        String location = "https://backend-url.example.com/v2/path/to/riches";
        String host = "api.example.com:443";
        String path = "/path/to/riches";
        this.setupTest(location, host, path);
        Assertions.assertThat((String)this.filter.fixedLocation(location, host, path, RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.AS_IN_REQUEST, this.config.getHostPortPattern(), this.config.getHostPortVersionPattern())).isEqualTo("https://api.example.com:443/path/to/riches");
    }

    @Test
    public void toStringFormat() {
        RewriteLocationResponseHeaderGatewayFilterFactory.Config config = new RewriteLocationResponseHeaderGatewayFilterFactory.Config().setStripVersion(RewriteLocationResponseHeaderGatewayFilterFactory.StripVersion.ALWAYS_STRIP).setLocationHeaderName("mylocation").setHostValue("myhost").setProtocols("myproto");
        GatewayFilter filter = new RewriteLocationResponseHeaderGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"ALWAYS_STRIP"})).contains(new CharSequence[]{"mylocation"})).contains(new CharSequence[]{"myhost"})).contains(new CharSequence[]{"myproto"});
    }
}

