/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.RewriteRequestParameterGatewayFilterFactory;
import org.springframework.http.HttpMethod;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

class RewriteRequestParameterGatewayFilterFactoryTests {
    RewriteRequestParameterGatewayFilterFactoryTests() {
    }

    @Test
    void toStringFormat() {
        RewriteRequestParameterGatewayFilterFactory.Config config = new RewriteRequestParameterGatewayFilterFactory.Config();
        config.setName("campaign");
        config.setReplacement("fall2023");
        GatewayFilter filter = new RewriteRequestParameterGatewayFilterFactory().apply(config);
        ((AbstractStringAssert)Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"campaign"})).contains(new CharSequence[]{"fall2023"});
    }

    @Test
    void rewriteRequestParameterFilterWorks() {
        this.testRewriteRequestParameterFilter("campaign", "fall2023", "size=small&campaign=old", Map.of("size", List.of("small"), "campaign", List.of("fall2023")));
    }

    @Test
    void rewriteRequestParameterFilterRewritesMultipleParamsWithSameName() {
        this.testRewriteRequestParameterFilter("campaign", "fall2023", "campaign=fall&size=small&campaign=old", Map.of("size", List.of("small"), "campaign", List.of("fall2023")));
    }

    @Test
    void rewriteRequestParameterFilterDoesNotAddParamIfNameNotFound() {
        this.testRewriteRequestParameterFilter("campaign", "winter2023", "color=green&sort=popular", Map.of("color", List.of("green"), "sort", List.of("popular")));
    }

    @Test
    void rewriteRequestParameterFilterWorksWithSpecialCharacters() {
        this.testRewriteRequestParameterFilter("campaign", "black friday~(1.A-B_C!)", "campaign=old&color=green", Map.of("campaign", List.of("black friday~(1.A-B_C!)"), "color", List.of("green")));
    }

    private void testRewriteRequestParameterFilter(String name, String replacement, String query, Map<String, List<String>> expectedQueryParams) {
        GatewayFilter filter = new RewriteRequestParameterGatewayFilterFactory().apply(config -> config.setReplacement(replacement).setName(name));
        URI url = UriComponentsBuilder.fromUriString((String)"http://localhost/get").query(query).build(true).toUri();
        MockServerHttpRequest request = MockServerHttpRequest.method((HttpMethod)HttpMethod.GET, (URI)url).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        GatewayFilterChain filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ServerWebExchange.class);
        Mockito.when((Object)filterChain.filter((ServerWebExchange)captor.capture())).thenReturn((Object)Mono.empty());
        filter.filter((ServerWebExchange)exchange, filterChain);
        ServerWebExchange webExchange = (ServerWebExchange)captor.getValue();
        MultiValueMap actualQueryParams = webExchange.getRequest().getQueryParams();
        Assertions.assertThat((Map)actualQueryParams).containsExactlyInAnyOrderEntriesOf(expectedQueryParams);
    }
}

