/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.SetRequestHostHeaderGatewayFilterFactory;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class SetRequestHostHeaderGatewayFilterFactoryTests
extends BaseWebClientTests {
    @Test
    public void setRequestHostHeaderFilterWorks() {
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.setrequesthostheader.org"}).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).hasEntrySatisfying((Object)"Host", val -> Assertions.assertThat((Object)val).isEqualTo((Object)"otherhost.io"));
        });
    }

    @Test
    public void toStringFormat() {
        SetRequestHostHeaderGatewayFilterFactory.Config config = new SetRequestHostHeaderGatewayFilterFactory.Config();
        config.setHost("myhost");
        GatewayFilter filter = new SetRequestHostHeaderGatewayFilterFactory().apply(config);
        Assertions.assertThat((String)filter.toString()).contains(new CharSequence[]{"myhost"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
    }
}

