/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.TokenRelayGatewayFilterFactory;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.server.context.SecurityContextServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class TokenRelayGatewayFilterFactoryTests {
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private ReactiveOAuth2AuthorizedClientManager authorizedClientManager;
    private MockServerHttpRequest request;
    private MockServerWebExchange mockExchange;
    private GatewayFilterChain filterChain;
    private ObjectProvider<ReactiveOAuth2AuthorizedClientManager> objectProvider;

    @BeforeEach
    public void init() {
        this.request = MockServerHttpRequest.get((String)"/hello", (Object[])new Object[0]).build();
        this.mockExchange = MockServerWebExchange.from((MockServerHttpRequest)this.request);
        this.filterChain = (GatewayFilterChain)Mockito.mock(GatewayFilterChain.class);
        Mockito.when((Object)this.filterChain.filter((ServerWebExchange)ArgumentMatchers.any(ServerWebExchange.class))).thenReturn((Object)Mono.empty());
        this.authorizedClientManager = (ReactiveOAuth2AuthorizedClientManager)Mockito.mock(ReactiveOAuth2AuthorizedClientManager.class);
        this.objectProvider = (ObjectProvider)Mockito.mock(ObjectProvider.class);
        Mockito.when((Object)((ReactiveOAuth2AuthorizedClientManager)this.objectProvider.getIfAvailable())).thenReturn((Object)this.authorizedClientManager);
    }

    @AfterEach
    public void after() {
    }

    @Test
    public void emptyPrincipal() {
        GatewayFilter filter = new TokenRelayGatewayFilterFactory(this.objectProvider).apply();
        filter.filter((ServerWebExchange)this.mockExchange, this.filterChain).block(TIMEOUT);
        Assertions.assertThat((Map)this.request.getHeaders()).doesNotContainKeys((Object[])new String[]{"Authorization"});
    }

    @Test
    public void whenPrincipalExistsAuthorizationHeaderAdded() {
        OAuth2AccessToken accessToken = (OAuth2AccessToken)Mockito.mock(OAuth2AccessToken.class);
        Mockito.when((Object)accessToken.getTokenValue()).thenReturn((Object)"mytoken");
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"myregistrationid").authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).clientId("myclientid").tokenUri("mytokenuri").build();
        OAuth2AuthorizedClient authorizedClient = new OAuth2AuthorizedClient(clientRegistration, "joe", accessToken);
        Mockito.when((Object)this.authorizedClientManager.authorize((OAuth2AuthorizeRequest)ArgumentMatchers.any(OAuth2AuthorizeRequest.class))).thenReturn((Object)Mono.just((Object)authorizedClient));
        OAuth2AuthenticationToken authenticationToken = new OAuth2AuthenticationToken((OAuth2User)Mockito.mock(OAuth2User.class), Collections.emptyList(), "myId");
        SecurityContextImpl securityContext = new SecurityContextImpl((Authentication)authenticationToken);
        SecurityContextServerWebExchange exchange = new SecurityContextServerWebExchange((ServerWebExchange)this.mockExchange, Mono.just((Object)securityContext));
        GatewayFilter filter = new TokenRelayGatewayFilterFactory(this.objectProvider).apply();
        filter.filter((ServerWebExchange)exchange, this.filterChain).block(TIMEOUT);
        ArgumentCaptor sweCaptor = ArgumentCaptor.forClass(ServerWebExchange.class);
        ((GatewayFilterChain)Mockito.verify((Object)this.filterChain)).filter((ServerWebExchange)sweCaptor.capture());
        ServerWebExchange mutatedServerWebExchange = (ServerWebExchange)sweCaptor.getValue();
        Assertions.assertThat((Map)mutatedServerWebExchange.getRequest().getHeaders()).containsEntry((Object)"Authorization", Collections.singletonList("Bearer mytoken"));
        ArgumentCaptor authorizeRequestCaptor = ArgumentCaptor.forClass(OAuth2AuthorizeRequest.class);
        ((ReactiveOAuth2AuthorizedClientManager)Mockito.verify((Object)this.authorizedClientManager)).authorize((OAuth2AuthorizeRequest)authorizeRequestCaptor.capture());
        OAuth2AuthorizeRequest authorizeRequest = (OAuth2AuthorizeRequest)authorizeRequestCaptor.getValue();
        Assertions.assertThat((String)authorizeRequest.getClientRegistrationId()).isEqualTo(authenticationToken.getAuthorizedClientRegistrationId());
        Assertions.assertThat((String)authorizeRequest.getClientRegistrationId()).isNotEqualTo((Object)clientRegistration.getRegistrationId());
    }

    @Test
    public void whenClientRegistrationIdConfiguredAuthorizationHeaderAdded() {
        OAuth2AccessToken accessToken = (OAuth2AccessToken)Mockito.mock(OAuth2AccessToken.class);
        Mockito.when((Object)accessToken.getTokenValue()).thenReturn((Object)"mytoken");
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"myregistrationid").authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).clientId("myclientid").tokenUri("mytokenuri").build();
        OAuth2AuthorizedClient authorizedClient = new OAuth2AuthorizedClient(clientRegistration, "steve", accessToken);
        Mockito.when((Object)this.authorizedClientManager.authorize((OAuth2AuthorizeRequest)ArgumentMatchers.any(OAuth2AuthorizeRequest.class))).thenReturn((Object)Mono.just((Object)authorizedClient));
        OAuth2AuthenticationToken authenticationToken = new OAuth2AuthenticationToken((OAuth2User)Mockito.mock(OAuth2User.class), Collections.emptyList(), "myId");
        SecurityContextImpl securityContext = new SecurityContextImpl((Authentication)authenticationToken);
        SecurityContextServerWebExchange exchange = new SecurityContextServerWebExchange((ServerWebExchange)this.mockExchange, Mono.just((Object)securityContext));
        AbstractGatewayFilterFactory.NameConfig config = new AbstractGatewayFilterFactory.NameConfig();
        config.setName(clientRegistration.getRegistrationId());
        GatewayFilter filter = new TokenRelayGatewayFilterFactory(this.objectProvider).apply(config);
        filter.filter((ServerWebExchange)exchange, this.filterChain).block(TIMEOUT);
        ArgumentCaptor sweCaptor = ArgumentCaptor.forClass(ServerWebExchange.class);
        ((GatewayFilterChain)Mockito.verify((Object)this.filterChain)).filter((ServerWebExchange)sweCaptor.capture());
        ServerWebExchange mutatedServerWebExchange = (ServerWebExchange)sweCaptor.getValue();
        Assertions.assertThat((Map)mutatedServerWebExchange.getRequest().getHeaders()).containsEntry((Object)"Authorization", Collections.singletonList("Bearer mytoken"));
        ArgumentCaptor authorizeRequestCaptor = ArgumentCaptor.forClass(OAuth2AuthorizeRequest.class);
        ((ReactiveOAuth2AuthorizedClientManager)Mockito.verify((Object)this.authorizedClientManager)).authorize((OAuth2AuthorizeRequest)authorizeRequestCaptor.capture());
        OAuth2AuthorizeRequest authorizeRequest = (OAuth2AuthorizeRequest)authorizeRequestCaptor.getValue();
        Assertions.assertThat((String)authorizeRequest.getClientRegistrationId()).isEqualTo(clientRegistration.getRegistrationId());
        Assertions.assertThat((String)authorizeRequest.getClientRegistrationId()).isNotEqualTo((Object)authenticationToken.getAuthorizedClientRegistrationId());
    }

    @Test
    public void principalIsNotOAuth2AuthenticationToken() {
        SecurityContextImpl securityContext = new SecurityContextImpl((Authentication)new TestingAuthenticationToken((Object)"my", null));
        SecurityContextServerWebExchange exchange = new SecurityContextServerWebExchange((ServerWebExchange)this.mockExchange, Mono.just((Object)securityContext));
        GatewayFilter filter = new TokenRelayGatewayFilterFactory(this.objectProvider).apply();
        filter.filter((ServerWebExchange)exchange, this.filterChain).block(TIMEOUT);
        Assertions.assertThat((Map)this.request.getHeaders()).doesNotContainKeys((Object[])new String[]{"Authorization"});
    }

    @Test
    public void whenPrincipalIsNotOAuth2AuthenticationTokenAndClientRegistrationIdConfiguredAuthorizationHeaderAdded() {
        OAuth2AccessToken accessToken = (OAuth2AccessToken)Mockito.mock(OAuth2AccessToken.class);
        Mockito.when((Object)accessToken.getTokenValue()).thenReturn((Object)"mytoken");
        ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)"myregistrationid").authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).clientId("myclientid").tokenUri("mytokenuri").build();
        OAuth2AuthorizedClient authorizedClient = new OAuth2AuthorizedClient(clientRegistration, "steve", accessToken);
        Mockito.when((Object)this.authorizedClientManager.authorize((OAuth2AuthorizeRequest)ArgumentMatchers.any(OAuth2AuthorizeRequest.class))).thenReturn((Object)Mono.just((Object)authorizedClient));
        TestingAuthenticationToken authenticationToken = new TestingAuthenticationToken((Object)"my", null);
        SecurityContextImpl securityContext = new SecurityContextImpl((Authentication)authenticationToken);
        SecurityContextServerWebExchange exchange = new SecurityContextServerWebExchange((ServerWebExchange)this.mockExchange, Mono.just((Object)securityContext));
        AbstractGatewayFilterFactory.NameConfig config = new AbstractGatewayFilterFactory.NameConfig();
        config.setName(clientRegistration.getRegistrationId());
        GatewayFilter filter = new TokenRelayGatewayFilterFactory(this.objectProvider).apply(config);
        filter.filter((ServerWebExchange)exchange, this.filterChain).block(TIMEOUT);
        ArgumentCaptor sweCaptor = ArgumentCaptor.forClass(ServerWebExchange.class);
        ((GatewayFilterChain)Mockito.verify((Object)this.filterChain)).filter((ServerWebExchange)sweCaptor.capture());
        ServerWebExchange mutatedServerWebExchange = (ServerWebExchange)sweCaptor.getValue();
        Assertions.assertThat((Map)mutatedServerWebExchange.getRequest().getHeaders()).containsEntry((Object)"Authorization", Collections.singletonList("Bearer mytoken"));
        ArgumentCaptor authorizeRequestCaptor = ArgumentCaptor.forClass(OAuth2AuthorizeRequest.class);
        ((ReactiveOAuth2AuthorizedClientManager)Mockito.verify((Object)this.authorizedClientManager)).authorize((OAuth2AuthorizeRequest)authorizeRequestCaptor.capture());
        OAuth2AuthorizeRequest authorizeRequest = (OAuth2AuthorizeRequest)authorizeRequestCaptor.getValue();
        Assertions.assertThat((String)authorizeRequest.getClientRegistrationId()).isEqualTo(clientRegistration.getRegistrationId());
    }
}

