/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;

class LocalResponseCacheUtilsTests {
    LocalResponseCacheUtilsTests() {
    }

    @ParameterizedTest
    @ValueSource(strings={"", "no-store", "no-store, wrong-no-cache", "s-no-cache"})
    void shouldNotIdentifyRequestAsNoCacheRequest(String cacheControl) {
        MockServerHttpRequest httpRequest = MockServerHttpRequest.get((String)"https://this", (Object[])new Object[0]).header("Cache-Control", new String[]{cacheControl}).build();
        boolean result = LocalResponseCacheUtils.isNoCacheRequest((ServerHttpRequest)httpRequest);
        Assertions.assertThat((boolean)result).isFalse();
    }

    @ParameterizedTest
    @ValueSource(strings={"no-cache", "s-no-cache, no-cache", "private,no-cache", " no-cache", "no-cache "})
    void shouldIdentifyRequestAsNoCacheRequest(String cacheControl) {
        MockServerHttpRequest httpRequest = MockServerHttpRequest.get((String)"https://this", (Object[])new Object[0]).header("Cache-Control", new String[]{cacheControl}).build();
        boolean result = LocalResponseCacheUtils.isNoCacheRequest((ServerHttpRequest)httpRequest);
        Assertions.assertThat((boolean)result).isTrue();
    }
}

