/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.keygenerator;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.HeaderKeyValueGenerator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.util.MultiValueMap;

class HeaderKeyValueGeneratorTest {
    private static final String HEADER_NAME = "X-Header";
    private static final String SINGLE_HEADER_VALUE = "header-value";
    private static final String VALUE1 = "value-1";
    private static final String VALUE2 = "value-2";
    private static final String SEPARATOR = ",";

    HeaderKeyValueGeneratorTest() {
    }

    @Test
    void exceptionIsThrown_whenConstructorHeaderIsNull() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> new HeaderKeyValueGenerator(null, SEPARATOR));
    }

    @Test
    void keyValuePatternIsGenerated_whenOneSingleValueHeaderIsFound() {
        HttpHeaders headers = new HttpHeaders();
        headers.set(HEADER_NAME, SINGLE_HEADER_VALUE);
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://this", (Object[])new Object[0]).headers((MultiValueMap)headers).build();
        String result = new HeaderKeyValueGenerator(HEADER_NAME, SEPARATOR).apply((ServerHttpRequest)request);
        Assertions.assertThat((String)result).isEqualTo("X-Header=header-value");
    }

    @Test
    void keyValuePatternIsGenerated_whenOneMultipleValueHeaderIsFound() {
        HttpHeaders headers = new HttpHeaders();
        headers.put(HEADER_NAME, List.of(VALUE1, VALUE2));
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://this", (Object[])new Object[0]).headers((MultiValueMap)headers).build();
        String result = new HeaderKeyValueGenerator(HEADER_NAME, SEPARATOR).apply((ServerHttpRequest)request);
        Assertions.assertThat((String)result).isEqualTo("X-Header=value-1,value-2");
    }

    @Test
    void sotedKeyValuePatternIsGenerated_whenOneMultipleUnsortedValueHeaderIsFound() {
        HttpHeaders headers = new HttpHeaders();
        headers.put(HEADER_NAME, List.of(VALUE2, VALUE1));
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://this", (Object[])new Object[0]).headers((MultiValueMap)headers).build();
        String result = new HeaderKeyValueGenerator(HEADER_NAME, SEPARATOR).apply((ServerHttpRequest)request);
        Assertions.assertThat((String)result).isEqualTo("X-Header=value-1,value-2");
    }
}

