/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.postprocessor;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.factory.cache.CachedResponse;
import org.springframework.cloud.gateway.filter.factory.cache.postprocessor.RemoveHeadersAfterCacheExchangeMutator;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

class RemoveHeaderAfterCacheExchangeMutatorTest {
    private static final String HTTP_HEADER_TO_REMOVE = "X-To-Remove";

    RemoveHeaderAfterCacheExchangeMutatorTest() {
    }

    @Test
    void onlyHeaderToRemoveFromResponseIsRemoved() {
        ServerWebExchange inputExchange = this.setupExchange(Map.of(HTTP_HEADER_TO_REMOVE, "A-Value"));
        RemoveHeadersAfterCacheExchangeMutator mutator = new RemoveHeadersAfterCacheExchangeMutator(new String[]{HTTP_HEADER_TO_REMOVE});
        CachedResponse cachedResponse = new CachedResponse.Builder((HttpStatusCode)HttpStatus.OK).build();
        mutator.accept(inputExchange, cachedResponse);
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)inputExchange.getResponse().getHeaders()).doesNotContainKey((Object)HTTP_HEADER_TO_REMOVE)).containsEntry((Object)"Cache-Control", List.of("max-age=60"))).containsEntry((Object)"Content-Type", List.of("application/octet-stream"))).hasSize(2);
    }

    @Test
    void multipleHeadersToRemoveFromResponseAreRemoved() {
        Map<String, String> headers = Map.of(HTTP_HEADER_TO_REMOVE, "A-Value", "Pragma", "void", "Expires", "0");
        ServerWebExchange inputExchange = this.setupExchange(headers);
        RemoveHeadersAfterCacheExchangeMutator mutator = new RemoveHeadersAfterCacheExchangeMutator(new String[]{HTTP_HEADER_TO_REMOVE, "Pragma", "Expires"});
        CachedResponse cachedResponse = new CachedResponse.Builder((HttpStatusCode)HttpStatus.OK).build();
        mutator.accept(inputExchange, cachedResponse);
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)inputExchange.getResponse().getHeaders()).doesNotContainKey((Object)HTTP_HEADER_TO_REMOVE)).doesNotContainKey((Object)"Pragma")).doesNotContainKey((Object)"Expires")).containsEntry((Object)"Cache-Control", List.of("max-age=60"))).containsEntry((Object)"Content-Type", List.of("application/octet-stream"))).hasSize(2);
    }

    @Test
    void headersAreNotModifiedIfHeaderToRemoveIsEmpty() {
        ServerWebExchange inputExchange = this.setupExchange(Map.of());
        RemoveHeadersAfterCacheExchangeMutator mutator = new RemoveHeadersAfterCacheExchangeMutator(new String[]{HTTP_HEADER_TO_REMOVE});
        CachedResponse cachedResponse = new CachedResponse.Builder((HttpStatusCode)HttpStatus.OK).build();
        mutator.accept(inputExchange, cachedResponse);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)inputExchange.getResponse().getHeaders()).containsEntry((Object)"Cache-Control", List.of("max-age=60"))).containsEntry((Object)"Content-Type", List.of("application/octet-stream"))).hasSize(2);
    }

    private ServerWebExchange setupExchange(Map<String, String> headersToAdd) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setCacheControl(CacheControl.maxAge((Duration)Duration.ofSeconds(60L)));
        responseHeaders.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headersToAdd.forEach((k, v) -> responseHeaders.set(k, v));
        MockServerHttpRequest httpRequest = MockServerHttpRequest.get((String)"https://this", (Object[])new Object[0]).build();
        MockServerWebExchange inputExchange = MockServerWebExchange.from((MockServerHttpRequest)httpRequest);
        MockServerHttpResponse httpResponse = inputExchange.getResponse();
        httpResponse.setStatusCode((HttpStatusCode)HttpStatus.OK);
        httpResponse.getHeaders().putAll((Map)responseHeaders);
        return inputExchange;
    }
}

