/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.headers.ForwardedHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

public class ForwardedHeadersFilterTests {
    public static Map<String, String> map(String ... values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("values must have even number of items: " + Arrays.asList(values));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < values.length; ++i) {
            map.put(values[i], values[++i]);
        }
        return map;
    }

    @Test
    public void forwardedHeaderDoesNotExist() throws UnknownHostException {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).header("Host", new String[]{"myhost"}).build();
        ForwardedHeadersFilter filter = new ForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((List)headers.get((Object)"Forwarded")).hasSize(1);
        List forwardeds = ForwardedHeadersFilter.parse((List)headers.get((Object)"Forwarded"));
        Assertions.assertThat((List)forwardeds).hasSize(1);
        ForwardedHeadersFilter.Forwarded forwarded = (ForwardedHeadersFilter.Forwarded)forwardeds.get(0);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)forwarded.getValues()).containsEntry((Object)"host", (Object)"myhost")).containsEntry((Object)"proto", (Object)"http")).containsEntry((Object)"for", (Object)"\"10.0.0.1:80\"");
    }

    @Test
    public void forwardedHeaderExists() throws UnknownHostException {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).header("Forwarded", new String[]{"for=12.34.56.78;host=example.com;proto=https; for=23.45.67.89"}).build();
        ForwardedHeadersFilter filter = new ForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((List)headers.get((Object)"Forwarded")).hasSize(2);
        List forwardeds = ForwardedHeadersFilter.parse((List)headers.get((Object)"Forwarded"));
        Assertions.assertThat((List)forwardeds).hasSize(2);
        ForwardedHeadersFilter.Forwarded addedForwardedHeader = (ForwardedHeadersFilter.Forwarded)forwardeds.get(0);
        ForwardedHeadersFilter.Forwarded existingForwardedHeader = (ForwardedHeadersFilter.Forwarded)forwardeds.get(1);
        ((MapAssert)Assertions.assertThat((Map)existingForwardedHeader.getValues()).containsEntry((Object)"proto", (Object)"http")).containsEntry((Object)"for", (Object)"\"10.0.0.1:80\"");
        ((MapAssert)Assertions.assertThat((Map)addedForwardedHeader.getValues()).containsEntry((Object)"proto", (Object)"https")).containsEntry((Object)"for", (Object)"23.45.67.89");
    }

    @Test
    public void noHostHeader() throws UnknownHostException {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 80)).build();
        ForwardedHeadersFilter filter = new ForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((List)headers.get((Object)"Forwarded")).hasSize(1);
        List forwardeds = ForwardedHeadersFilter.parse((List)headers.get((Object)"Forwarded"));
        Assertions.assertThat((List)forwardeds).hasSize(1);
        ForwardedHeadersFilter.Forwarded forwarded = (ForwardedHeadersFilter.Forwarded)forwardeds.get(0);
        ((MapAssert)Assertions.assertThat((Map)forwarded.getValues()).containsEntry((Object)"proto", (Object)"http")).containsEntry((Object)"for", (Object)"\"10.0.0.1:80\"");
    }

    @Test
    public void correctIPv6RemoteAddressMapping() throws UnknownHostException {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]).remoteAddress(new InetSocketAddress(InetAddress.getByName("2001:db8:cafe:0:0:0:0:17"), 80)).header("Host", new String[]{"myhost"}).build();
        ForwardedHeadersFilter filter = new ForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((List)headers.get((Object)"Forwarded")).hasSize(1);
        List forwardeds = ForwardedHeadersFilter.parse((List)headers.get((Object)"Forwarded"));
        Assertions.assertThat((List)forwardeds).hasSize(1);
        ForwardedHeadersFilter.Forwarded forwarded = (ForwardedHeadersFilter.Forwarded)forwardeds.get(0);
        Assertions.assertThat((Map)forwarded.getValues()).containsEntry((Object)"for", (Object)"\"[2001:db8:cafe:0:0:0:0:17]:80\"");
    }

    @Test
    public void unresolvedRemoteAddressFallsBackToHostName() throws UnknownHostException {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]).remoteAddress(InetSocketAddress.createUnresolved("unresolvable-hostname", 80)).build();
        ForwardedHeadersFilter filter = new ForwardedHeadersFilter();
        HttpHeaders headers = filter.filter(request.getHeaders(), (ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)request));
        Assertions.assertThat((List)headers.get((Object)"Forwarded")).hasSize(1);
        List forwardeds = ForwardedHeadersFilter.parse((List)headers.get((Object)"Forwarded"));
        Assertions.assertThat((List)forwardeds).hasSize(1);
        ForwardedHeadersFilter.Forwarded forwarded = (ForwardedHeadersFilter.Forwarded)forwardeds.get(0);
        ((MapAssert)Assertions.assertThat((Map)forwarded.getValues()).containsEntry((Object)"proto", (Object)"http")).containsEntry((Object)"for", (Object)"\"unresolvable-hostname:80\"");
    }

    @Test
    public void forwardedParsedCorrectly() {
        String[] valid = new String[]{"for=\"_gazonk\"", "for=192.0.2.60;proto=http;by=203.0.113.43", "for=192.0.2.43, for=198.51.100.17", "for=12.34.56.78;host=example.com;proto=https, for=23.45.67.89", "for=12.34.56.78, for=23.45.67.89;secret=egah2CGj55fSJFs, for=10.1.2.3", "For=\"[2001:db8:cafe::17]:4711\""};
        ArrayList<List<Map>> expectedFor = new ArrayList<List<Map>>();
        expectedFor.add(Arrays.asList(ForwardedHeadersFilterTests.map("for", "\"_gazonk\"")));
        expectedFor.add(Arrays.asList(ForwardedHeadersFilterTests.map("for", "192.0.2.60", "proto", "http", "by", "203.0.113.43")));
        expectedFor.add(Arrays.asList(ForwardedHeadersFilterTests.map("for", "192.0.2.43"), ForwardedHeadersFilterTests.map("for", "198.51.100.17")));
        expectedFor.add(Arrays.asList(ForwardedHeadersFilterTests.map("for", "12.34.56.78", "host", "example.com", "proto", "https"), ForwardedHeadersFilterTests.map("for", "23.45.67.89")));
        expectedFor.add(Arrays.asList(ForwardedHeadersFilterTests.map("for", "12.34.56.78"), ForwardedHeadersFilterTests.map("for", "23.45.67.89", "secret", "egah2CGj55fSJFs"), ForwardedHeadersFilterTests.map("for", "10.1.2.3")));
        expectedFor.add(Arrays.asList(ForwardedHeadersFilterTests.map("for", "\"[2001:db8:cafe::17]:4711\"")));
        for (int i = 0; i < valid.length; ++i) {
            String value = valid[i];
            String[] values = StringUtils.tokenizeToStringArray((String)value, (String)",");
            List results = ForwardedHeadersFilter.parse(Arrays.asList(values));
            Assertions.assertThat((List)results).hasSize(values.length);
            Assertions.assertThat((Object)((ForwardedHeadersFilter.Forwarded)results.get(0))).isNotNull();
            List expected = (List)expectedFor.get(i);
            Assertions.assertThat((List)expected).hasSize(results.size());
            for (int j = 0; j < results.size(); ++j) {
                ForwardedHeadersFilter.Forwarded forwarded = (ForwardedHeadersFilter.Forwarded)results.get(j);
                ((MapAssert)Assertions.assertThat((Map)forwarded.getValues()).hasSize(((Map)expected.get(j)).size())).containsAllEntriesOf((Map)expected.get(j));
            }
        }
    }
}

