/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.headers.RemoveHopByHopHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

public class RemoveHopByHopHeadersFilterTests {
    @Test
    public void happyPath() {
        MockServerHttpRequest.BaseBuilder builder = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]);
        RemoveHopByHopHeadersFilter.HEADERS_REMOVED_ON_REQUEST.forEach(header -> builder.header(header, new String[]{header + "1"}));
        this.testFilter(MockServerWebExchange.from((MockServerHttpRequest.BaseBuilder)builder), new String[0]);
    }

    @Test
    public void caseInsensitive() {
        MockServerHttpRequest.BaseBuilder builder = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]);
        RemoveHopByHopHeadersFilter.HEADERS_REMOVED_ON_REQUEST.forEach(header -> builder.header(header.toLowerCase(Locale.ROOT), new String[]{header + "1"}));
        this.testFilter(MockServerWebExchange.from((MockServerHttpRequest.BaseBuilder)builder), new String[0]);
    }

    @Test
    public void caseInsensitiveCustom() {
        MockServerHttpRequest.BaseBuilder builder = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]);
        RemoveHopByHopHeadersFilter.HEADERS_REMOVED_ON_REQUEST.forEach(header -> builder.header(StringUtils.capitalize((String)header.toLowerCase(Locale.ROOT)), new String[]{header + "1"}));
        LinkedHashSet customHeaders = new LinkedHashSet();
        RemoveHopByHopHeadersFilter.HEADERS_REMOVED_ON_REQUEST.forEach(header -> {
            String newHeader = header.charAt(0) + StringUtils.capitalize((String)header.substring(1));
            customHeaders.add(newHeader);
        });
        RemoveHopByHopHeadersFilter filter = new RemoveHopByHopHeadersFilter();
        filter.setHeaders(customHeaders);
        this.testFilter(filter, MockServerWebExchange.from((MockServerHttpRequest.BaseBuilder)builder), new String[0]);
    }

    @Test
    public void removesHeadersListedInConnectionHeader() {
        MockServerHttpRequest.BaseBuilder builder = MockServerHttpRequest.get((String)"http://localhost/get", (Object[])new Object[0]);
        String arbitraryConnectionOption = "xyz";
        Assumptions.assumeThat((Collection)RemoveHopByHopHeadersFilter.HEADERS_REMOVED_ON_REQUEST).doesNotContain((Object[])new String[]{arbitraryConnectionOption});
        builder.header("Connection", new String[]{"upgrade", "keep-alive", arbitraryConnectionOption.toUpperCase(Locale.ROOT)});
        builder.header("Upgrade", new String[]{"WebSocket"});
        builder.header("Keep-Alive", new String[]{"timeout=5"});
        builder.header(arbitraryConnectionOption, new String[]{""});
        this.testFilter(MockServerWebExchange.from((MockServerHttpRequest.BaseBuilder)builder), arbitraryConnectionOption);
    }

    private void testFilter(MockServerWebExchange exchange, String ... additionalHeaders) {
        this.testFilter(new RemoveHopByHopHeadersFilter(), exchange, additionalHeaders);
    }

    private void testFilter(RemoveHopByHopHeadersFilter filter, MockServerWebExchange exchange, String ... additionalHeaders) {
        HttpHeaders headers = filter.filter(exchange.getRequest().getHeaders(), (ServerWebExchange)exchange);
        HashSet<String> toRemove = new HashSet<String>(RemoveHopByHopHeadersFilter.HEADERS_REMOVED_ON_REQUEST);
        toRemove.addAll(Arrays.asList(additionalHeaders));
        Assertions.assertThat((Map)headers).doesNotContainKeys((Object[])toRemove.toArray(new String[0]));
    }
}

