/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import brave.Tracing;
import brave.handler.SpanHandler;
import brave.propagation.B3Propagation;
import brave.sampler.Sampler;
import brave.test.TestSpanHandler;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.tck.TestObservationRegistry;
import io.micrometer.tracing.BaggageManager;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.brave.bridge.BraveBaggageManager;
import io.micrometer.tracing.brave.bridge.BraveCurrentTraceContext;
import io.micrometer.tracing.brave.bridge.BraveFinishedSpan;
import io.micrometer.tracing.brave.bridge.BravePropagator;
import io.micrometer.tracing.brave.bridge.BraveTracer;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import io.micrometer.tracing.test.simple.SpansAssert;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayPropagatingSenderTracingObservationHandler;
import org.springframework.cloud.gateway.filter.headers.observation.ObservedRequestHttpHeadersFilter;
import org.springframework.cloud.gateway.filter.headers.observation.ObservedResponseHttpHeadersFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.util.context.Context;

class B3BraveObservedHttpHeadersFilterTests {
    TestSpanHandler testSpanHandler = new TestSpanHandler();
    Tracing tracing = Tracing.newBuilder().propagationFactory(B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE).build()).addSpanHandler((SpanHandler)this.testSpanHandler).sampler(Sampler.ALWAYS_SAMPLE).build();
    Tracer tracer = new BraveTracer(this.tracing.tracer(), (CurrentTraceContext)new BraveCurrentTraceContext(this.tracing.currentTraceContext()), (BaggageManager)new BraveBaggageManager());
    Propagator propagator = new BravePropagator(this.tracing);

    B3BraveObservedHttpHeadersFilterTests() {
    }

    @Test
    void shouldWorkWithB3SingleHeader() {
        TestObservationRegistry observationRegistry = TestObservationRegistry.create();
        observationRegistry.observationConfig().observationHandler((ObservationHandler)new ObservationHandler.FirstMatchingCompositeObservationHandler(new ObservationHandler[]{new GatewayPropagatingSenderTracingObservationHandler(this.tracer, this.propagator, Collections.singletonList("X-A")), new DefaultTracingObservationHandler(this.tracer)}));
        Observation.createNotStarted((String)"parent", (ObservationRegistry)observationRegistry).observe(() -> {
            MockServerHttpRequest.BaseBuilder builder = MockServerHttpRequest.get((String)"http://localhost:8080/{foo}", (Object[])new Object[]{"get"}).header("X-A", new String[]{"aValue"});
            TraceContext context = this.tracer.currentTraceContext().context();
            this.propagator.inject(context, (Object)builder, (b, k, v) -> b.header(k, new String[]{v}));
            MockServerHttpRequest request = builder.build();
            MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
            ServerWebExchangeUtils.putUriTemplateVariables((ServerWebExchange)exchange, Map.of("foo", "get"));
            exchange.getResponse().setStatusCode(HttpStatusCode.valueOf((int)200));
            Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("foo")).uri("http://localhost:8080/")).order(1)).predicate(serverWebExchange -> true).build();
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, route);
            Context ctx = Context.of(Map.of("micrometer.observation", observationRegistry.getCurrentObservation()));
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REACTOR_CONTEXT_ATTR, ctx);
            ObservedRequestHttpHeadersFilter requestHttpHeadersFilter = new ObservedRequestHttpHeadersFilter((ObservationRegistry)observationRegistry);
            ObservedResponseHttpHeadersFilter responseHttpHeadersFilter = new ObservedResponseHttpHeadersFilter();
            HttpHeaders headers = requestHttpHeadersFilter.filter(request.getHeaders(), (ServerWebExchange)exchange);
            headers = responseHttpHeadersFilter.filter(headers, (ServerWebExchange)exchange);
            ((MapAssert)Assertions.assertThat((Map)headers).containsOnlyKeys((Object[])new String[]{"X-A", "b3"})).doesNotContainEntry((Object)"b3", (Object)request.getHeaders().get((Object)"b3"));
            Assertions.assertThat((String)((String)headers.get((Object)"b3").get(0))).matches((CharSequence)("^" + context.traceId() + "-(.*)-1-" + context.spanId() + "$"));
            List finishedSpans = this.testSpanHandler.spans().stream().map(BraveFinishedSpan::new).collect(Collectors.toList());
            SpansAssert.then(finishedSpans).hasASpanWithName("HTTP GET", spanAssert -> spanAssert.hasTag("spring.cloud.gateway.route.id", "foo").hasTag("http.method", "GET").hasTag("http.status_code", "200").hasTag("spring.cloud.gateway.route.uri", "http://localhost:8080/").hasTag("http.uri", "http://localhost:8080/get"));
        });
    }
}

