/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers.observation;

import io.micrometer.observation.Observation;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.filter.headers.observation.ObservedResponseHttpHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

class ObservedResponseHttpHeadersFilterTests {
    ObservedResponseHttpHeadersFilterTests() {
    }

    @Test
    void shouldDoNothingWhenObservationIsNoOp() {
        MockServerHttpRequest request = MockServerHttpRequest.get((String)"/get", (Object[])new Object[0]).build();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_OBSERVATION_ATTR, Observation.NOOP);
        ObservedResponseHttpHeadersFilter filter = new ObservedResponseHttpHeadersFilter();
        BDDAssertions.thenNoException().isThrownBy(() -> ObservedResponseHttpHeadersFilterTests.lambda$shouldDoNothingWhenObservationIsNoOp$0(filter, (ServerWebExchange)exchange));
    }

    private static /* synthetic */ void lambda$shouldDoNothingWhenObservationIsNoOp$0(ObservedResponseHttpHeadersFilter filter, ServerWebExchange exchange) throws Throwable {
        filter.filter(new HttpHeaders(), exchange);
    }
}

