/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.ratelimit;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.gateway.filter.ratelimit.RateLimiter;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.util.TestSocketUtils;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.ExchangeFilterFunctions;
import reactor.core.publisher.Mono;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT, properties={"spring.security.user.name=user", "spring.security.user.password={noop}password", "spring.security.user.roles=USER"})
@ActiveProfiles(value={"principalname"})
public class PrincipalNameKeyResolverIntegrationTests {
    @LocalServerPort
    protected int port = 0;
    protected WebTestClient client;
    protected String baseUri;

    @BeforeAll
    public static void beforeClass() {
        System.setProperty("server.port", String.valueOf(TestSocketUtils.findAvailableTcpPort()));
    }

    @AfterAll
    public static void afterClass() {
        System.clearProperty("server.port");
    }

    @BeforeEach
    public void setup() {
        this.baseUri = "http://localhost:" + this.port;
        this.client = WebTestClient.bindToServer().baseUrl(this.baseUri).build();
    }

    @Test
    public void keyResolverWorks() {
        this.client.mutate().filter(ExchangeFilterFunctions.basicAuthentication((String)"user", (String)"password")).build().get().uri("/myapi/1", new Object[0]).exchange().expectStatus().isOk().expectBody().json("{\"user\":\"1\"}");
    }

    @RestController
    @RequestMapping(value={"/downstream"})
    @EnableAutoConfiguration
    @SpringBootConfiguration
    protected static class TestConfig {
        @Value(value="${server.port}")
        private int port;

        protected TestConfig() {
        }

        @GetMapping(value={"/myapi/{id}"})
        public Map<String, String> myapi(@PathVariable String id, Principal principal) {
            return Collections.singletonMap(principal.getName(), id);
        }

        @Bean
        public RouteLocator customRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route(r -> r.path(new String[]{"/myapi/**"}).filters(f -> f.requestRateLimiter(c -> c.setRateLimiter((RateLimiter)this.myRateLimiter())).prefixPath("/downstream")).uri("http://localhost:" + this.port)).build();
        }

        @Bean
        @Primary
        MyRateLimiter myRateLimiter() {
            return new MyRateLimiter();
        }

        @Bean
        SecurityWebFilterChain springWebFilterChain(ServerHttpSecurity http) {
            return ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.httpBasic().and().authorizeExchange().pathMatchers(new String[]{"/myapi/**"})).authenticated().anyExchange().permitAll().and().build();
        }

        class MyRateLimiter
        implements RateLimiter<Object> {
            private HashMap<String, Object> map = new HashMap();

            MyRateLimiter() {
            }

            public Mono<RateLimiter.Response> isAllowed(String routeId, String id) {
                return Mono.just((Object)new RateLimiter.Response(true, Collections.singletonMap("X-Value", "5000000")));
            }

            public Class<Object> getConfigClass() {
                return Object.class;
            }

            public Map<String, Object> getConfig() {
                return this.map;
            }

            public Object newConfig() {
                return null;
            }
        }
    }
}

