/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class AsyncPredicateTest {
    @Test
    public void andPredicateShouldNotTestRightOperatorIfLeftOperatorIsFalse() {
        TestAsyncPredicate<Object> left = new TestAsyncPredicate<Object>(o -> false);
        TestAsyncPredicate<Object> right = new TestAsyncPredicate<Object>(o -> true);
        Publisher andTest = (Publisher)left.and(right).apply(new Object());
        StepVerifier.create((Publisher)andTest).expectNext((Object)false).expectComplete().verify();
        left.assertTested();
        right.assertUntested();
    }

    @Test
    public void andPredicateShouldTestRightOperatorIfLeftOperatorIsTrue() {
        TestAsyncPredicate<Object> left = new TestAsyncPredicate<Object>(o -> true);
        TestAsyncPredicate<Object> right = new TestAsyncPredicate<Object>(o -> false);
        Publisher andTest = (Publisher)left.and(right).apply(new Object());
        StepVerifier.create((Publisher)andTest).expectNext((Object)false).expectComplete().verify();
        left.assertTested();
        right.assertTested();
    }

    @Test
    public void orPredicateShouldNotTestRightOperatorIfLeftOperatorIsTrue() {
        TestAsyncPredicate<Object> left = new TestAsyncPredicate<Object>(o -> true);
        TestAsyncPredicate<Object> right = new TestAsyncPredicate<Object>(o -> false);
        Publisher orTest = (Publisher)left.or(right).apply(new Object());
        StepVerifier.create((Publisher)orTest).expectNext((Object)true).expectComplete().verify();
        left.assertTested();
        right.assertUntested();
    }

    @Test
    public void orPredicateShouldTestRightOperatorIfLeftOperatorIsFalse() {
        TestAsyncPredicate<Object> left = new TestAsyncPredicate<Object>(o -> false);
        TestAsyncPredicate<Object> right = new TestAsyncPredicate<Object>(o -> true);
        Publisher orTest = (Publisher)left.or(right).apply(new Object());
        StepVerifier.create((Publisher)orTest).expectNext((Object)true).expectComplete().verify();
        left.assertTested();
        right.assertTested();
    }

    @Test
    public void negateOperatorWorks() {
        TestAsyncPredicate<Object> falsePredicate = new TestAsyncPredicate<Object>(o -> false);
        TestAsyncPredicate<Object> truePredicate = new TestAsyncPredicate<Object>(o -> true);
        Publisher falseNot = (Publisher)falsePredicate.negate().apply(new Object());
        Publisher trueNot = (Publisher)truePredicate.negate().apply(new Object());
        StepVerifier.create((Publisher)falseNot).expectNext((Object)true).expectComplete().verify();
        StepVerifier.create((Publisher)trueNot).expectNext((Object)false).expectComplete().verify();
        falsePredicate.assertTested();
        truePredicate.assertTested();
    }

    private static final class TestAsyncPredicate<T>
    implements AsyncPredicate<T> {
        private final Predicate<T> delegate;
        private boolean tested = false;

        private TestAsyncPredicate(Predicate<T> predicate) {
            this.delegate = predicate;
        }

        public Publisher<Boolean> apply(T t) {
            this.tested = true;
            return Mono.just((Object)this.delegate.test(t));
        }

        @DisplayName(value="predicate must have been tested")
        public void assertTested() {
            Assertions.assertTrue((boolean)this.tested);
        }

        @DisplayName(value="predicate must not have been tested")
        public void assertUntested() {
            Assertions.assertFalse((boolean)this.tested);
        }
    }
}

