/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.FilterDefinition;
import org.springframework.cloud.gateway.handler.FilteringWebHandler;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.BodyInserters;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, properties={"spring.cloud.gateway.route-filter-cache-enabled=true", "management.endpoint.gateway.enabled=true", "management.endpoints.web.exposure.include=*", "spring.cloud.gateway.actuator.verbose.enabled=true"})
@DirtiesContext
public class FilteringWebHandlerCacheEnabledIntegrationTests
extends BaseWebClientTests {
    @Autowired
    private FilteringWebHandler webHandler;

    @Test
    public void filteringWebHandlerCacheEnabledWorks() {
        this.callRoute("/get");
        Assertions.assertThat((Map)this.webHandler.getRouteFilterMap()).hasSize(1);
        this.callRoute("/anything/testRoute1");
        Assertions.assertThat((Map)this.webHandler.getRouteFilterMap()).hasSize(2);
        RouteDefinition testRouteDefinition = new RouteDefinition();
        testRouteDefinition.setId("testRoute2");
        testRouteDefinition.setUri(URI.create("lb://testservice"));
        FilterDefinition filterDefinition = new FilterDefinition("PrefixPath=/httpbin");
        testRouteDefinition.getFilters().add(filterDefinition);
        PredicateDefinition hostRoutePredicateDefinition = new PredicateDefinition("Path=/anything/testRoute2");
        testRouteDefinition.setPredicates(Arrays.asList(hostRoutePredicateDefinition));
        ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/routes/testRoute2", new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(BodyInserters.fromValue((Object)testRouteDefinition)).exchange().expectStatus().isCreated();
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("http://localhost:" + this.port + "/actuator/gateway/refresh", new Object[0])).exchange().expectStatus().isOk();
        this.callRoute("/get");
        this.callRoute("/anything/testRoute1");
        this.callRoute("/anything/testRoute2");
        Assertions.assertThat((Map)this.webHandler.getRouteFilterMap()).hasSize(3);
    }

    private void callRoute(String uri) {
        this.testClient.mutate().responseTimeout(Duration.ofMinutes(5L)).build().get().uri(uri, new Object[0]).exchange().expectStatus().isOk();
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    public static class TestConfig {
        @Bean
        RouteLocator testRouteLocator(RouteLocatorBuilder builder) {
            return builder.routes().route("get_route", r -> r.path(new String[]{"/get"}).filters(f -> f.prefixPath("/httpbin")).uri("lb://testservice")).route("testRoute1", r -> r.path(new String[]{"/anything/testRoute1"}).filters(f -> f.prefixPath("/httpbin")).uri("lb://testservice")).build();
        }
    }
}

