/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.handler.predicate.BeforeRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.BetweenRoutePredicateFactoryTests;

public class BeforeRoutePredicateFactoryTests {
    @Test
    public void beforeStringWorks() {
        String dateString = BetweenRoutePredicateFactoryTests.minusHours(1);
        boolean result = this.runPredicate(dateString);
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void afterStringWorks() {
        String dateString = BetweenRoutePredicateFactoryTests.plusHours(1);
        boolean result = this.runPredicate(dateString);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void beforeEpochWorks() {
        String dateString = BetweenRoutePredicateFactoryTests.minusHoursMillis(1);
        boolean result = this.runPredicate(dateString);
        Assertions.assertThat((boolean)result).isFalse();
    }

    @Test
    public void afterEpochWorks() {
        String dateString = BetweenRoutePredicateFactoryTests.plusHoursMillis(1);
        boolean result = this.runPredicate(dateString);
        Assertions.assertThat((boolean)result).isTrue();
    }

    @Test
    public void testPredicates() {
        boolean result = new BeforeRoutePredicateFactory().apply(c -> c.setDatetime(ZonedDateTime.now().minusHours(2L))).test(BetweenRoutePredicateFactoryTests.getExchange());
        Assertions.assertThat((boolean)result).isFalse();
    }

    private boolean runPredicate(String dateString) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datetime", dateString);
        BeforeRoutePredicateFactory factory = new BeforeRoutePredicateFactory();
        BeforeRoutePredicateFactory.Config config = (BeforeRoutePredicateFactory.Config)BetweenRoutePredicateFactoryTests.bindConfig(map, factory);
        return factory.apply(config).test(BetweenRoutePredicateFactoryTests.getExchange());
    }

    @Test
    public void toStringFormat() {
        BeforeRoutePredicateFactory.Config config = new BeforeRoutePredicateFactory.Config();
        config.setDatetime(ZonedDateTime.now());
        Predicate predicate = new BeforeRoutePredicateFactory().apply(config);
        Assertions.assertThat((String)predicate.toString()).contains(new CharSequence[]{"Before: " + config.getDatetime()});
    }

    @Test
    public void testConfig() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            BeforeRoutePredicateFactory.Config config = new BeforeRoutePredicateFactory.Config();
            config.setDatetime(ZonedDateTime.now());
            Assertions.assertThat((boolean)validator.validate((Object)config, new Class[0]).isEmpty()).isTrue();
        }
    }

    @Test
    public void testConfigNullField() {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            BeforeRoutePredicateFactory.Config config = new BeforeRoutePredicateFactory.Config();
            Set validate = validator.validate((Object)config, new Class[0]);
            Assertions.assertThat((boolean)validate.isEmpty()).isFalse();
            Assertions.assertThat((int)validate.size()).isEqualTo(1);
        }
    }
}

