/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.function.Supplier;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.filter.WeightCalculatorWebFilter;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@ActiveProfiles(value={"weights-404"})
@DirtiesContext
class WeightRoutePredicateFactoryYaml404Tests
extends BaseWebClientTests {
    @Autowired
    private WeightCalculatorWebFilter filter;

    WeightRoutePredicateFactoryYaml404Tests() {
    }

    private static Supplier<Double> getRandom(double value) {
        Supplier random = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)((Double)random.get())).thenReturn((Object)value);
        return random;
    }

    @Test
    void weightsFromYamlNot404() {
        this.filter.setRandomSupplier(WeightRoutePredicateFactoryYaml404Tests.getRandom(0.5));
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.weight4041.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"weight_first_404_test_1"});
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    static class TestConfig {
        TestConfig(WeightCalculatorWebFilter filter) {
            Supplier<Double> random = WeightRoutePredicateFactoryYaml404Tests.getRandom(0.4);
            filter.setRandomSupplier(random);
        }
    }
}

