/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.event.RefreshRoutesResultEvent;
import org.springframework.cloud.gateway.route.CachingRouteLocator;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import reactor.core.publisher.Flux;

public class CachingRouteLocatorTests {
    @Test
    public void getRoutesWorks() {
        Route route1 = this.route(1);
        Route route2 = this.route(2);
        CachingRouteLocator locator = new CachingRouteLocator(() -> Flux.just((Object[])new Route[]{route2, route1}));
        List routes = (List)locator.getRoutes().collectList().block();
        Assertions.assertThat((List)routes).containsExactly((Object[])new Route[]{route1, route2});
    }

    @Test
    public void refreshWorks() {
        final Route route1 = this.route(1);
        final Route route2 = this.route(2);
        CachingRouteLocator locator = new CachingRouteLocator(new RouteLocator(){
            int i = 0;

            public Flux<Route> getRoutes() {
                if (this.i++ == 0) {
                    return Flux.just((Object)route2);
                }
                return Flux.just((Object[])new Route[]{route2, route1});
            }
        });
        List routes = (List)locator.getRoutes().collectList().block();
        Assertions.assertThat((List)routes).containsExactly((Object[])new Route[]{route2});
        routes = (List)locator.refresh().collectList().block();
        Assertions.assertThat((List)routes).containsExactly((Object[])new Route[]{route1, route2});
    }

    @Test
    public void refreshWorksWhenFirstRefreshSuccessAndOtherError() throws InterruptedException {
        final Route route1 = this.route(1);
        final Route route2 = this.route(2);
        CachingRouteLocator locator = new CachingRouteLocator(new RouteLocator(){
            int i = 0;

            public Flux<Route> getRoutes() {
                if (this.i == 0) {
                    ++this.i;
                    return Flux.just((Object)route1);
                }
                if (this.i == 1) {
                    ++this.i;
                    return Flux.just((Object)route2).map(route -> {
                        throw new RuntimeException("in chain.");
                    });
                }
                if (this.i == 2) {
                    ++this.i;
                    throw new RuntimeException("call getRoutes error.");
                }
                return Flux.just((Object)route2);
            }
        });
        List routes = (List)locator.getRoutes().collectList().block();
        Assertions.assertThat((List)routes).containsExactly((Object[])new Route[]{route1});
        ArrayList<RefreshRoutesResultEvent> resultEvents = new ArrayList<RefreshRoutesResultEvent>();
        this.waitUntilRefreshFinished(locator, resultEvents);
        Assertions.assertThat(resultEvents).hasSize(1);
        Assertions.assertThat((String)((RefreshRoutesResultEvent)resultEvents.get(0)).getThrowable().getMessage()).isEqualTo("in chain.");
        Assertions.assertThat((boolean)((RefreshRoutesResultEvent)resultEvents.get(0)).isSuccess()).isEqualTo(false);
        Assertions.assertThat((List)((List)locator.getRoutes().collectList().block())).containsExactly((Object[])new Route[]{route1});
        this.waitUntilRefreshFinished(locator, resultEvents);
        Assertions.assertThat(resultEvents).hasSize(2);
        Assertions.assertThat((String)((RefreshRoutesResultEvent)resultEvents.get(1)).getThrowable().getMessage()).isEqualTo("call getRoutes error.");
        Assertions.assertThat((boolean)((RefreshRoutesResultEvent)resultEvents.get(1)).isSuccess()).isEqualTo(false);
        Assertions.assertThat((List)((List)locator.getRoutes().collectList().block())).containsExactly((Object[])new Route[]{route1});
        this.waitUntilRefreshFinished(locator, resultEvents);
        Assertions.assertThat(resultEvents).hasSize(3);
        Assertions.assertThat((boolean)((RefreshRoutesResultEvent)resultEvents.get(2)).isSuccess()).isEqualTo(true);
        Assertions.assertThat((List)((List)locator.getRoutes().collectList().block())).containsExactly((Object[])new Route[]{route2});
    }

    private void waitUntilRefreshFinished(CachingRouteLocator locator, List<RefreshRoutesResultEvent> resultEvents) throws InterruptedException {
        CountDownLatch cdl = new CountDownLatch(1);
        locator.setApplicationEventPublisher(o -> {
            resultEvents.add((RefreshRoutesResultEvent)o);
            cdl.countDown();
        });
        locator.onApplicationEvent(new RefreshRoutesEvent((Object)this));
        Assertions.assertThat((boolean)cdl.await(5L, TimeUnit.SECONDS)).isTrue();
    }

    Route route(int id) {
        return ((Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id(String.valueOf(id))).uri("http://localhost/" + id)).order(id)).predicate(exchange -> true).build();
    }
}

