/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.util.Maps;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteDefinition;

public class RouteTests {
    @Test
    public void defaultHttpPort() {
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("1")).predicate(exchange -> true).uri("http://acme.com")).build();
        Assertions.assertThat((URI)route.getUri()).hasHost("acme.com").hasScheme("http").hasPort(80);
    }

    @Test
    public void defaultHttpsPort() {
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("1")).predicate(exchange -> true).uri("https://acme.com")).build();
        Assertions.assertThat((URI)route.getUri()).hasHost("acme.com").hasScheme("https").hasPort(443);
    }

    @Test
    public void fullUri() {
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("1")).predicate(exchange -> true).uri("http://acme.com:8080")).build();
        Assertions.assertThat((URI)route.getUri()).hasHost("acme.com").hasScheme("http").hasPort(8080);
    }

    @Test
    public void nullScheme() {
        Assertions.assertThatThrownBy(() -> ((Route.AsyncBuilder)Route.async().id("1")).predicate(exchange -> true).uri("/pathonly")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void localhostNoSchemeFails() {
        Assertions.assertThatThrownBy(() -> ((Route.AsyncBuilder)Route.async().id("1")).predicate(exchange -> true).uri("localhost:8080")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void noOpWorks() {
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("1")).predicate(exchange -> true).uri("no://op")).build();
        Assertions.assertThat((URI)route.getUri()).hasScheme("no").hasHost("op");
    }

    @Test
    public void forwardWorks() {
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("1")).predicate(exchange -> true).uri("forward:/some/path")).build();
        Assertions.assertThat((URI)route.getUri()).hasScheme("forward").hasPath("/some/path");
    }

    @Test
    public void defaultMetadataToEmpty() {
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("1")).predicate(exchange -> true).uri("http://acme.com:8080")).build();
        Assertions.assertThat((Map)route.getMetadata()).isEmpty();
    }

    @Test
    public void isAbleToAddMetadata() {
        Route route = ((Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("1")).predicate(exchange -> true).uri("http://acme.com:8080")).metadata(Maps.newHashMap((Object)"key", (Object)"value"))).metadata("key2", (Object)"value2")).build();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)route.getMetadata()).hasSize(2)).containsEntry((Object)"key", (Object)"value")).containsEntry((Object)"key2", (Object)"value2");
    }

    @Test
    public void metadataIsAddedFromDefinition() {
        RouteDefinition definition = new RouteDefinition();
        definition.setId("1");
        definition.setUri(URI.create("http://acme.com:8080"));
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("key", "value");
        metadata.put("key2", "value2");
        definition.setMetadata(metadata);
        Route route = Route.async((RouteDefinition)definition).predicate(exchange -> true).build();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)route.getMetadata()).hasSize(2)).containsEntry((Object)"key", (Object)"value")).containsEntry((Object)"key2", (Object)"value2");
    }
}

