/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route.builder;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.rewrite.ModifyResponseBodyGatewayFilterFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.builder.GatewayFilterSpec;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GatewayFilterSpecTests {
    @Test
    public void orderedInterfaceRespected() {
        this.testFilter(MyOrderedFilter.class, new MyOrderedFilter(), 1000, null, false);
    }

    @Test
    public void orderedInterfaceRespectedWhenOrderSpecified() {
        this.testFilter(MyOrderedFilter.class, new MyOrderedFilter(), 1000, 5, false);
    }

    @Test
    public void unorderedWithDefaultOrder() {
        this.testFilter(OrderedGatewayFilter.class, new MyUnorderedFilter(), 0, null, false);
    }

    @Test
    public void forceOrderWithOrderedInterface() {
        this.testFilter(OrderedGatewayFilter.class, new MyOrderedFilter(), 5, 5, true);
    }

    private void testFilter(Class<? extends GatewayFilter> type, GatewayFilter gatewayFilter, int expectedOrder, Integer specifiedOrder, Boolean forceOrder) {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        Route.AsyncBuilder routeBuilder = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("123")).uri("abc:123")).predicate(exchange -> true);
        RouteLocatorBuilder.Builder routes = new RouteLocatorBuilder(context).routes();
        GatewayFilterSpec spec = new GatewayFilterSpec(routeBuilder, routes);
        if (specifiedOrder != null) {
            if (forceOrder != null) {
                spec.filter(gatewayFilter, specifiedOrder.intValue(), forceOrder.booleanValue());
            } else {
                spec.filter(gatewayFilter, specifiedOrder.intValue());
            }
        } else {
            spec.filter(gatewayFilter);
        }
        Route route = routeBuilder.build();
        Assertions.assertThat((List)route.getFilters()).hasSize(1);
        this.assertFilter((GatewayFilter)route.getFilters().get(0), type, expectedOrder);
    }

    private void assertFilter(GatewayFilter filter, Class<? extends GatewayFilter> type, int order) {
        Assertions.assertThat((Object)filter).isInstanceOf(type);
        Ordered ordered = (Ordered)filter;
        Assertions.assertThat((int)ordered.getOrder()).isEqualTo(order);
    }

    @Test
    public void testFilters() {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        Route.AsyncBuilder routeBuilder = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("123")).uri("abc:123")).predicate(exchange -> true);
        RouteLocatorBuilder.Builder routes = new RouteLocatorBuilder(context).routes();
        GatewayFilterSpec spec = new GatewayFilterSpec(routeBuilder, routes);
        spec.filters(new GatewayFilter[]{new MyUnorderedFilter(), new MyOrderedFilter()});
        Route route = routeBuilder.build();
        Assertions.assertThat((List)route.getFilters()).hasSize(2);
        this.assertFilter((GatewayFilter)route.getFilters().get(0), OrderedGatewayFilter.class, 0);
        this.assertFilter((GatewayFilter)route.getFilters().get(1), MyOrderedFilter.class, 1000);
    }

    @Test
    public void shouldSetModifyBodyResponseFilterWithRewriteFunction() {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        Route.AsyncBuilder routeBuilder = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("123")).uri("abc:123")).predicate(exchange -> true);
        Mockito.when((Object)((ModifyResponseBodyGatewayFilterFactory)context.getBean(ModifyResponseBodyGatewayFilterFactory.class))).thenReturn((Object)new ModifyResponseBodyGatewayFilterFactory(HandlerStrategies.withDefaults().messageReaders(), Collections.emptySet(), Collections.emptySet()));
        RouteLocatorBuilder.Builder routes = new RouteLocatorBuilder(context).routes();
        GatewayFilterSpec spec = new GatewayFilterSpec(routeBuilder, routes);
        spec.modifyResponseBody(String.class, String.class, (exchange, s) -> Mono.just((Object)s));
        Route route = routeBuilder.build();
        Assertions.assertThat((List)route.getFilters()).hasSize(1);
        this.assertFilter((GatewayFilter)route.getFilters().get(0), ModifyResponseBodyGatewayFilterFactory.ModifyResponseGatewayFilter.class, -2);
    }

    @Test
    public void shouldSetModifyBodyResponseFilterWithRewriteFunctionAndEmptyBodySupplier() {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        Route.AsyncBuilder routeBuilder = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("123")).uri("abc:123")).predicate(exchange -> true);
        Mockito.when((Object)((ModifyResponseBodyGatewayFilterFactory)context.getBean(ModifyResponseBodyGatewayFilterFactory.class))).thenReturn((Object)new ModifyResponseBodyGatewayFilterFactory(HandlerStrategies.withDefaults().messageReaders(), Collections.emptySet(), Collections.emptySet()));
        RouteLocatorBuilder.Builder routes = new RouteLocatorBuilder(context).routes();
        GatewayFilterSpec spec = new GatewayFilterSpec(routeBuilder, routes);
        spec.modifyResponseBody(String.class, String.class, (exchange, s) -> Mono.just((Object)(s == null ? "emptybody" : s)));
        Route route = routeBuilder.build();
        Assertions.assertThat((List)route.getFilters()).hasSize(1);
        this.assertFilter((GatewayFilter)route.getFilters().get(0), ModifyResponseBodyGatewayFilterFactory.ModifyResponseGatewayFilter.class, -2);
    }

    @Test
    public void shouldSetModifyBodyResponseFilterWithRewriteFunctionAndNewContentType() {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        Route.AsyncBuilder routeBuilder = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("123")).uri("abc:123")).predicate(exchange -> true);
        Mockito.when((Object)((ModifyResponseBodyGatewayFilterFactory)context.getBean(ModifyResponseBodyGatewayFilterFactory.class))).thenReturn((Object)new ModifyResponseBodyGatewayFilterFactory(HandlerStrategies.withDefaults().messageReaders(), Collections.emptySet(), Collections.emptySet()));
        RouteLocatorBuilder.Builder routes = new RouteLocatorBuilder(context).routes();
        GatewayFilterSpec spec = new GatewayFilterSpec(routeBuilder, routes);
        spec.modifyResponseBody(String.class, String.class, "application/json", (exchange, s) -> Mono.just((Object)s));
        Route route = routeBuilder.build();
        Assertions.assertThat((List)route.getFilters()).hasSize(1);
        this.assertFilter((GatewayFilter)route.getFilters().get(0), ModifyResponseBodyGatewayFilterFactory.ModifyResponseGatewayFilter.class, -2);
    }

    @Test
    public void shouldSetModifyBodyResponseFilterWithConfigConsumer() {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        Route.AsyncBuilder routeBuilder = ((Route.AsyncBuilder)((Route.AsyncBuilder)Route.async().id("123")).uri("abc:123")).predicate(exchange -> true);
        Mockito.when((Object)((ModifyResponseBodyGatewayFilterFactory)context.getBean(ModifyResponseBodyGatewayFilterFactory.class))).thenReturn((Object)new ModifyResponseBodyGatewayFilterFactory(HandlerStrategies.withDefaults().messageReaders(), Collections.emptySet(), Collections.emptySet()));
        RouteLocatorBuilder.Builder routes = new RouteLocatorBuilder(context).routes();
        GatewayFilterSpec spec = new GatewayFilterSpec(routeBuilder, routes);
        spec.modifyResponseBody(smth -> new ModifyResponseBodyGatewayFilterFactory.Config().setRewriteFunction(String.class, String.class, (exchange, s) -> Mono.just((Object)s)));
        Route route = routeBuilder.build();
        Assertions.assertThat((List)route.getFilters()).hasSize(1);
        this.assertFilter((GatewayFilter)route.getFilters().get(0), ModifyResponseBodyGatewayFilterFactory.ModifyResponseGatewayFilter.class, -2);
    }

    protected static class MyOrderedFilter
    implements GatewayFilter,
    Ordered {
        protected MyOrderedFilter() {
        }

        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            return Mono.empty();
        }

        public int getOrder() {
            return 1000;
        }
    }

    protected static class MyUnorderedFilter
    implements GatewayFilter {
        protected MyUnorderedFilter() {
        }

        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            return Mono.empty();
        }
    }
}

