/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route.builder;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.Config;
import org.springframework.cloud.gateway.route.builder.RouteDslKt;
import org.springframework.cloud.gateway.route.builder.RouteDslTests;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.kotlin.core.publisher.MonoExtensionsKt;
import reactor.test.StepVerifier;

@SpringBootTest(classes={Config.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/springframework/cloud/gateway/route/builder/RouteDslTests;", "", "()V", "builder", "Lorg/springframework/cloud/gateway/route/builder/RouteLocatorBuilder;", "getBuilder", "()Lorg/springframework/cloud/gateway/route/builder/RouteLocatorBuilder;", "setBuilder", "(Lorg/springframework/cloud/gateway/route/builder/RouteLocatorBuilder;)V", "dslWithFunctionParameters", "", "sampleRouteDsl", "spring-cloud-gateway-server"})
public final class RouteDslTests {
    @Autowired
    public RouteLocatorBuilder builder;

    @NotNull
    public final RouteLocatorBuilder getBuilder() {
        RouteLocatorBuilder routeLocatorBuilder = this.builder;
        if (routeLocatorBuilder != null) {
            return routeLocatorBuilder;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"builder");
        return null;
    }

    public final void setBuilder(@NotNull RouteLocatorBuilder routeLocatorBuilder) {
        Intrinsics.checkNotNullParameter((Object)routeLocatorBuilder, (String)"<set-?>");
        this.builder = routeLocatorBuilder;
    }

    @Test
    public final void sampleRouteDsl() {
        RouteLocator routeLocator2 = RouteDslKt.routes((RouteLocatorBuilder)this.getBuilder(), (Function1)sampleRouteDsl.routeLocator.1.INSTANCE);
        StepVerifier.create((Publisher)((Publisher)routeLocator2.getRoutes())).expectNextMatches(arg_0 -> RouteDslTests.sampleRouteDsl$lambda$0(sampleRouteDsl.1.INSTANCE, arg_0)).expectNextMatches(arg_0 -> RouteDslTests.sampleRouteDsl$lambda$1(sampleRouteDsl.2.INSTANCE, arg_0)).expectComplete().verify();
        String[] stringArray = new String[]{"test.abc.org"};
        MockServerWebExchange mockServerWebExchange = MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)"/image/webp", (Object[])new Object[0]).header("Host", stringArray).build());
        Intrinsics.checkNotNullExpressionValue((Object)mockServerWebExchange, (String)"from(...)");
        ServerWebExchange sampleExchange = (ServerWebExchange)mockServerWebExchange;
        Flux filteredRoutes2 = routeLocator2.getRoutes().filter(arg_0 -> RouteDslTests.sampleRouteDsl$lambda$2((Function1)new Function1<Route, Boolean>(sampleExchange){
            final /* synthetic */ ServerWebExchange $sampleExchange;
            {
                this.$sampleExchange = $sampleExchange;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Route it) {
                this.$sampleExchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR, it.getId());
                Object object = it.getPredicate().apply((Object)this.$sampleExchange);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
                Object object2 = MonoExtensionsKt.toMono((Publisher)((Publisher)object)).block();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"block(...)");
                return (Boolean)object2;
            }
        }, arg_0));
        StepVerifier.create((Publisher)((Publisher)filteredRoutes2)).expectNextMatches(arg_0 -> RouteDslTests.sampleRouteDsl$lambda$3(sampleRouteDsl.3.INSTANCE, arg_0)).expectComplete().verify();
    }

    @Test
    public final void dslWithFunctionParameters() {
        RouteLocator routerLocator2 = RouteDslKt.routes((RouteLocatorBuilder)this.getBuilder(), (Function1)dslWithFunctionParameters.routerLocator.1.INSTANCE);
        StepVerifier.create((Publisher)((Publisher)routerLocator2.getRoutes())).expectNextMatches(arg_0 -> RouteDslTests.dslWithFunctionParameters$lambda$4(dslWithFunctionParameters.1.INSTANCE, arg_0)).expectNextMatches(arg_0 -> RouteDslTests.dslWithFunctionParameters$lambda$5(dslWithFunctionParameters.2.INSTANCE, arg_0)).expectComplete().verify();
    }

    private static final boolean sampleRouteDsl$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean sampleRouteDsl$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean sampleRouteDsl$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean sampleRouteDsl$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean dslWithFunctionParameters$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean dslWithFunctionParameters$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

