/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.PathContainer;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerWebExchangeUtilsTests {
    @Test
    public void expandWorks() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("foo", "bar");
        vars.put("baz", "bam");
        MockServerWebExchange exchange = this.mockExchange(vars);
        String expanded = ServerWebExchangeUtils.expand((ServerWebExchange)exchange, (String)"my-{foo}-{baz}");
        Assertions.assertThat((String)expanded).isEqualTo("my-bar-bam");
        expanded = ServerWebExchangeUtils.expand((ServerWebExchange)exchange, (String)"my-noop");
        Assertions.assertThat((String)expanded).isEqualTo("my-noop");
    }

    @Test
    public void missingVarThrowsException() {
        MockServerWebExchange exchange = this.mockExchange(Collections.emptyMap());
        Assertions.assertThatThrownBy(() -> ServerWebExchangeUtils.expand((ServerWebExchange)exchange, (String)"my-{foo}-{baz}")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void defaultDataBufferHandling() {
        MockServerWebExchange exchange = this.mockExchange(Collections.emptyMap());
        exchange.getAttributes().put("cachedRequestBody", "foo");
        ServerWebExchangeUtils.cacheRequestBodyAndRequest((ServerWebExchange)exchange, serverHttpRequest -> ServerRequest.create((ServerWebExchange)exchange.mutate().request(serverHttpRequest).build(), (List)HandlerStrategies.withDefaults().messageReaders()).bodyToMono(DefaultDataBuffer.class)).block();
    }

    @Test
    public void duplicatedCachingDataBufferHandling() {
        MockServerWebExchange exchange = this.mockExchange(HttpMethod.POST, Collections.emptyMap());
        DataBuffer dataBufferBeforeCaching = exchange.getResponse().bufferFactory().wrap("Cached buffer".getBytes(StandardCharsets.UTF_8));
        exchange.getAttributes().put("cachedRequestBody", dataBufferBeforeCaching);
        ServerWebExchangeUtils.cacheRequestBodyAndRequest((ServerWebExchange)exchange, serverHttpRequest -> ServerRequest.create((ServerWebExchange)exchange.mutate().request(serverHttpRequest).build(), (List)HandlerStrategies.withDefaults().messageReaders()).bodyToMono(DefaultDataBuffer.class)).block();
        DataBuffer dataBufferAfterCached = (DataBuffer)exchange.getAttribute("cachedRequestBody");
        Assertions.assertThat((Object)dataBufferBeforeCaching).isEqualTo((Object)dataBufferAfterCached);
    }

    @Test
    public void forwardedRequestsHaveDisruptiveAttributesAndHeadersRemoved() {
        DispatcherHandler handler = (DispatcherHandler)Mockito.mock(DispatcherHandler.class);
        Mockito.when((Object)handler.handle((ServerWebExchange)ArgumentMatchers.any(ServerWebExchange.class))).thenReturn((Object)Mono.empty());
        ServerWebExchange originalExchange = this.mockExchange(Map.of()).mutate().request(request -> request.headers(headers -> headers.setOrigin("https://example.com"))).build();
        originalExchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_PATH_CONTAINER_ATTR, PathContainer.parsePath((String)"/example/path"));
        ServerWebExchangeUtils.handle((DispatcherHandler)handler, (ServerWebExchange)originalExchange).block();
        ((DispatcherHandler)Mockito.verify((Object)handler)).handle((ServerWebExchange)ArgumentMatchers.assertArg(exchange -> {
            ((MapAssert)Assertions.assertThat((Map)exchange.getAttributes()).as("exchange attributes", new Object[0])).doesNotContainKey((Object)ServerWebExchangeUtils.GATEWAY_PREDICATE_PATH_CONTAINER_ATTR);
            ((MapAssert)Assertions.assertThat((Map)exchange.getRequest().getHeaders()).as("request headers", new Object[0])).doesNotContainKey((Object)"Origin");
        }));
    }

    private MockServerWebExchange mockExchange(Map<String, String> vars) {
        return this.mockExchange(HttpMethod.GET, vars);
    }

    private MockServerWebExchange mockExchange(HttpMethod method, Map<String, String> vars) {
        MockServerHttpRequest request = null;
        if (HttpMethod.GET.equals((Object)method)) {
            request = MockServerHttpRequest.get((String)"/get", (Object[])new Object[0]).build();
        } else if (HttpMethod.POST.equals((Object)method)) {
            request = MockServerHttpRequest.post((String)"/post", (Object[])new Object[0]).body("post body");
        }
        ((ObjectAssert)Assertions.assertThat((Object)request).as("Method was not one of GET or POST", new Object[0])).isNotNull();
        MockServerWebExchange exchange = MockServerWebExchange.from((MockServerHttpRequest)request);
        ServerWebExchangeUtils.putUriTemplateVariables((ServerWebExchange)exchange, vars);
        return exchange;
    }
}

