/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support.tagsprovider;

import io.micrometer.core.instrument.Tags;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.boot.autoconfigure.AutoConfigurations;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.test.context.runner.ApplicationContextRunner;
import org.springframework.cloud.gateway.config.GatewayMetricsAutoConfiguration;
import org.springframework.cloud.gateway.support.tagsprovider.PropertiesTagsProvider;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.web.server.MockServerWebExchange;
import org.springframework.web.server.ServerWebExchange;

public class PropertiesTagsProviderTests {
    private final ApplicationContextRunner contextRunner = new ApplicationContextRunner();

    @Test
    public void test() {
        ((ApplicationContextRunner)((ApplicationContextRunner)this.contextRunner.withConfiguration((Configurations)AutoConfigurations.of((Class[])new Class[]{GatewayMetricsAutoConfiguration.class}))).withPropertyValues(new String[]{"spring.cloud.gateway.metrics.tags.foo1=bar1", "spring.cloud.gateway.metrics.tags.foo2=bar2"})).run(context -> {
            PropertiesTagsProvider provider = (PropertiesTagsProvider)context.getBean(PropertiesTagsProvider.class);
            Tags tags = provider.apply((ServerWebExchange)MockServerWebExchange.from((MockServerHttpRequest)MockServerHttpRequest.get((String)"", (Object[])new Object[0]).build()));
            Assertions.assertThat((Iterable)tags).isEqualTo((Object)Tags.of((String[])new String[]{"foo1", "bar1", "foo2", "bar2"}));
        });
    }
}

