/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test;

import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.test.HttpBinCompatibleController;
import org.springframework.cloud.gateway.test.PermitAllSecurityConfiguration;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.ServiceInstanceListSuppliers;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class BaseWebClientTests {
    protected static final String HANDLER_MAPPER_HEADER = "X-Gateway-Handler-Mapper-Class";
    protected static final String ROUTE_ID_HEADER = "X-Gateway-RouteDefinition-Id";
    protected static final Duration DURATION = Duration.ofSeconds(5L);
    public static final String SERVICE_ID = "testservice";
    @LocalServerPort
    protected int port = 0;
    protected WebTestClient testClient;
    protected WebClient webClient;
    protected String baseUri;

    @BeforeEach
    public void setup() throws Exception {
        this.setup((ClientHttpConnector)new ReactorClientHttpConnector(), "http://localhost:" + this.port);
    }

    protected void setup(ClientHttpConnector httpConnector, String baseUri) {
        this.baseUri = baseUri;
        this.webClient = WebClient.builder().clientConnector(httpConnector).baseUrl(this.baseUri).build();
        DefaultUriBuilderFactory uriBuilderFactory = new DefaultUriBuilderFactory(this.baseUri);
        uriBuilderFactory.setParserType(UriComponentsBuilder.ParserType.WHAT_WG);
        this.testClient = WebTestClient.bindToServer((ClientHttpConnector)httpConnector).uriBuilderFactory((UriBuilderFactory)uriBuilderFactory).baseUrl(this.baseUri).build();
    }

    public static class TestLoadBalancerConfig {
        @LocalServerPort
        protected int port = 0;

        @Bean
        public ServiceInstanceListSupplier staticServiceInstanceListSupplier() {
            return ServiceInstanceListSuppliers.from((String)BaseWebClientTests.SERVICE_ID, (ServiceInstance[])new ServiceInstance[]{new DefaultServiceInstance("testservice-1", BaseWebClientTests.SERVICE_ID, "localhost", this.port, false)});
        }
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={DefaultTestConfig.class})
    public static class MainConfig {
    }

    public static class RecursiveHttpbinFilter
    implements GlobalFilter {
        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            if (exchange.getRequest().getPath().toString().contains("httpbin/httpbin")) {
                return Mono.error((Throwable)new IllegalStateException("recursive call to /httpbin"));
            }
            return chain.filter(exchange);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @LoadBalancerClient(name="testservice", configuration={TestLoadBalancerConfig.class})
    @Import(value={PermitAllSecurityConfiguration.class})
    public static class DefaultTestConfig {
        private static final Log log = LogFactory.getLog(DefaultTestConfig.class);

        @Bean
        public HttpBinCompatibleController httpBinController() {
            return new HttpBinCompatibleController();
        }

        @Bean
        public RecursiveHttpbinFilter recursiveHttpbinFilter() {
            return new RecursiveHttpbinFilter();
        }

        @Bean
        @Order(value=500)
        public GlobalFilter modifyResponseFilter() {
            return (exchange, chain) -> {
                Route route;
                log.info((Object)"modifyResponseFilter start");
                String value = (String)exchange.getAttributeOrDefault(ServerWebExchangeUtils.GATEWAY_HANDLER_MAPPER_ATTR, (Object)"N/A");
                if (!exchange.getResponse().isCommitted()) {
                    exchange.getResponse().getHeaders().add(BaseWebClientTests.HANDLER_MAPPER_HEADER, value);
                }
                if ((route = (Route)exchange.getAttributeOrDefault(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, null)) != null && !exchange.getResponse().isCommitted()) {
                    exchange.getResponse().getHeaders().add(BaseWebClientTests.ROUTE_ID_HEADER, route.getId());
                }
                return chain.filter(exchange);
            };
        }
    }
}

