/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.WeightCalculatorWebFilter;
import org.springframework.cloud.gateway.handler.RoutePredicateHandlerMapping;
import org.springframework.cloud.gateway.route.CachingRouteLocator;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.test.BaseWebClientTests;
import org.springframework.cloud.gateway.test.TestUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
class GatewayIntegrationTests
extends BaseWebClientTests {
    @Autowired
    private GatewayProperties properties;
    @Autowired
    private ApplicationContext context;

    GatewayIntegrationTests() {
    }

    @Test
    void listenersInOrder() {
        Assertions.assertThat((Object)this.context).isInstanceOf(AbstractApplicationContext.class);
        AbstractApplicationContext ctxt = (AbstractApplicationContext)this.context;
        ArrayList applicationListeners = new ArrayList(ctxt.getApplicationListeners());
        AnnotationAwareOrderComparator.sort(applicationListeners);
        int weightFilterIndex = applicationListeners.indexOf(this.context.getBean(WeightCalculatorWebFilter.class));
        int routeLocatorIndex = applicationListeners.indexOf(this.context.getBean(CachingRouteLocator.class));
        ((AbstractBooleanAssert)Assertions.assertThat((weightFilterIndex > routeLocatorIndex ? 1 : 0) != 0).as("CachingRouteLocator is after WeightCalculatorWebFilter", new Object[0])).isTrue();
    }

    @Test
    void checkFilterIsDisabled() {
        Optional<RouteDefinition> disabledRoute = this.properties.getRoutes().stream().filter(r -> "disabled_config_test".equals(r.getId())).findFirst();
        ((OptionalAssert)((OptionalAssert)Assertions.assertThat(disabledRoute).as("Disabled route is present", new Object[0])).isPresent()).get().hasFieldOrPropertyWithValue("enabled", (Object)false);
    }

    @Test
    void complexContentTypeWorks() {
        ((WebTestClient.RequestBodySpec)this.testClient.post().uri("/headers", new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)"testdata").header("Host", new String[]{"www.complexcontenttype.org"}).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsEntry((Object)"Content-Type", (Object)"application/json");
        });
    }

    @Test
    void forwardedHeadersWork() {
        this.testClient.get().uri("/headers", new Object[0]).exchange().expectStatus().isOk().expectBody(Map.class).consumeWith(result -> {
            Map<String, Object> headers = TestUtils.getMap((Map)result.getResponseBody(), "headers");
            Assertions.assertThat(headers).containsKeys((Object[])new String[]{"Forwarded", "X-Forwarded-For", "X-Forwarded-Host", "X-Forwarded-Port", "X-Forwarded-Proto"});
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((Object)headers.get("Forwarded")).asString().contains(new CharSequence[]{"proto=http"})).contains(new CharSequence[]{"host=\"localhost:"})).contains(new CharSequence[]{"for=\"127.0.0.1:"});
            Assertions.assertThat((Object)headers.get("X-Forwarded-Host")).asString().isEqualTo("localhost:" + this.port);
            Assertions.assertThat((Object)headers.get("X-Forwarded-Port")).asString().isEqualTo("" + this.port);
            Assertions.assertThat((Object)headers.get("X-Forwarded-Proto")).asString().isEqualTo("http");
        });
    }

    @Test
    void compositeRouteWorks() {
        this.testClient.get().uri("/headers?foo=bar&baz", new Object[0]).header("Host", new String[]{"www.foo.org"}).header("X-Request-Id", new String[]{"123"}).cookie("chocolate", "chip").exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-Handler-Mapper-Class", new String[]{RoutePredicateHandlerMapping.class.getSimpleName()}).expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"host_foo_path_headers_to_httpbin"}).expectHeader().valueEquals("X-Response-Foo", new String[]{"Bar"});
    }

    @Test
    void defaultFiltersWorks() {
        Assertions.assertThat((List)this.properties.getDefaultFilters()).isNotEmpty();
        this.testClient.get().uri("/headers", new Object[0]).header("Host", new String[]{"www.addresponseheader.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Response-Default-Foo", new String[]{"Default-Bar"}).returnResult(Object.class).consumeWith(result -> {
            HttpHeaders httpHeaders = result.getResponseHeaders();
            Assertions.assertThat((List)httpHeaders.get((Object)"X-Response-Default-Foo")).hasSize(1);
        });
    }

    @Test
    void loadBalancerFilterWorks() {
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.loadbalancerclient.org"}).exchange().expectStatus().isOk().expectHeader().valueEquals("X-Gateway-RouteDefinition-Id", new String[]{"load_balancer_client_test"});
    }

    @Test
    void loadBalancerFilterNoClientWorks() {
        this.testClient.get().uri("/get", new Object[0]).header("Host", new String[]{"www.loadbalancerclientempty.org"}).exchange().expectStatus().value((Matcher)new BaseMatcher<Integer>(){

            public boolean matches(Object item) {
                if (Integer.class.isInstance(item)) {
                    Integer toMatch = (Integer)item;
                    return toMatch == 503;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("Expected 503");
            }
        });
    }

    @Test
    void noContentType() {
        this.testClient.get().uri("/nocontenttype", new Object[0]).exchange().expectStatus().is2xxSuccessful();
    }

    @EnableAutoConfiguration
    @SpringBootConfiguration
    @Import(value={BaseWebClientTests.DefaultTestConfig.class})
    @RestController
    static class TestConfig {
        private static final Log log = LogFactory.getLog(TestConfig.class);

        TestConfig() {
        }

        private static Mono<Void> postFilterWork(ServerWebExchange exchange) {
            log.info((Object)"postFilterWork");
            exchange.getResponse().getHeaders().add("X-Post-Header", "AddedAfterRoute");
            return Mono.empty();
        }

        @GetMapping(value={"/httpbin/nocontenttype"})
        ResponseEntity<Void> nocontenttype() {
            return ResponseEntity.status((int)204).build();
        }

        @Bean
        @Order(value=-1)
        GlobalFilter postFilter() {
            return (exchange, chain) -> {
                log.info((Object)"postFilter start");
                return chain.filter(exchange).then(TestConfig.postFilterWork(exchange));
            };
        }
    }
}

