/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.protobuf.ProtobufFactory;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchema;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchemaLoader;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ClientCalls;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.config.GrpcSslConfigurer;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JsonToGrpcGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    private final GrpcSslConfigurer grpcSslConfigurer;
    private final ResourceLoader resourceLoader;

    public JsonToGrpcGatewayFilterFactory(GrpcSslConfigurer grpcSslConfigurer, ResourceLoader resourceLoader) {
        super(Config.class);
        this.grpcSslConfigurer = grpcSslConfigurer;
        this.resourceLoader = resourceLoader;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("protoDescriptor", "protoFile", "service", "method");
    }

    @Override
    public GatewayFilter apply(final Config config) {
        GatewayFilter filter = new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                GRPCResponseDecorator modifiedResponse = new GRPCResponseDecorator(exchange, config);
                ServerWebExchangeUtils.setAlreadyRouted(exchange);
                return modifiedResponse.writeWith((Publisher<? extends DataBuffer>)exchange.getRequest().getBody()).then(chain.filter(exchange.mutate().response((ServerHttpResponse)modifiedResponse).build()));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(JsonToGrpcGatewayFilterFactory.this).toString();
            }
        };
        int order = -2;
        return new OrderedGatewayFilter(filter, order);
    }

    public static class Config {
        private String protoDescriptor;
        private String protoFile;
        private String service;
        private String method;

        public String getProtoDescriptor() {
            return this.protoDescriptor;
        }

        public Config setProtoDescriptor(String protoDescriptor) {
            this.protoDescriptor = protoDescriptor;
            return this;
        }

        public String getProtoFile() {
            return this.protoFile;
        }

        public Config setProtoFile(String protoFile) {
            this.protoFile = protoFile;
            return this;
        }

        public String getService() {
            return this.service;
        }

        public Config setService(String service) {
            this.service = service;
            return this;
        }

        public String getMethod() {
            return this.method;
        }

        public Config setMethod(String method) {
            this.method = method;
            return this;
        }
    }

    class GRPCResponseDecorator
    extends ServerHttpResponseDecorator {
        private final ServerWebExchange exchange;
        private final Descriptors.Descriptor descriptor;
        private final ObjectWriter objectWriter;
        private final ObjectReader objectReader;
        private final ClientCall<DynamicMessage, DynamicMessage> clientCall;
        private final ObjectNode objectNode;

        GRPCResponseDecorator(ServerWebExchange exchange, Config config) {
            super(exchange.getResponse());
            this.exchange = exchange;
            try {
                Resource descriptorFile = JsonToGrpcGatewayFilterFactory.this.resourceLoader.getResource(config.getProtoDescriptor());
                Resource protoFile = JsonToGrpcGatewayFilterFactory.this.resourceLoader.getResource(config.getProtoFile());
                this.descriptor = DescriptorProtos.FileDescriptorProto.parseFrom((InputStream)descriptorFile.getInputStream()).getDescriptorForType();
                Descriptors.MethodDescriptor methodDescriptor = this.getMethodDescriptor(config, descriptorFile.getInputStream());
                Descriptors.ServiceDescriptor serviceDescriptor = methodDescriptor.getService();
                Descriptors.Descriptor outputType = methodDescriptor.getOutputType();
                this.clientCall = this.createClientCallForType(config, serviceDescriptor, outputType);
                ProtobufSchema schema = ProtobufSchemaLoader.std.load(protoFile.getInputStream());
                ProtobufSchema responseType = schema.withRootType(outputType.getName());
                ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new ProtobufFactory());
                objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
                this.objectWriter = objectMapper.writer((FormatSchema)schema);
                this.objectReader = objectMapper.readerFor(JsonNode.class).with((FormatSchema)responseType);
                this.objectNode = objectMapper.createObjectNode();
            }
            catch (Descriptors.DescriptorValidationException | IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
            this.exchange.getResponse().getHeaders().set("Content-Type", "application/json");
            return this.getDelegate().writeWith((Publisher)this.deserializeJSONRequest().map(this.callGRPCServer()).map(this.serialiseGRPCResponse()).map(this.wrapGRPCResponse()).cast(DataBuffer.class).last());
        }

        private ClientCall<DynamicMessage, DynamicMessage> createClientCallForType(Config config, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.Descriptor outputType) {
            MethodDescriptor.Marshaller marshaller = ProtoUtils.marshaller((Message)DynamicMessage.newBuilder((Descriptors.Descriptor)outputType).build());
            MethodDescriptor methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNKNOWN).setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceDescriptor.getFullName(), (String)config.getMethod())).setRequestMarshaller(marshaller).setResponseMarshaller(marshaller).build();
            ManagedChannel channel = this.createChannel();
            return channel.newCall(methodDescriptor, CallOptions.DEFAULT);
        }

        private Descriptors.MethodDescriptor getMethodDescriptor(Config config, InputStream descriptorFile) throws IOException, Descriptors.DescriptorValidationException {
            DescriptorProtos.FileDescriptorSet fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)descriptorFile);
            DescriptorProtos.FileDescriptorProto fileProto = fileDescriptorSet.getFile(0);
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
            Descriptors.ServiceDescriptor serviceDescriptor = fileDescriptor.findServiceByName(config.getService());
            if (serviceDescriptor == null) {
                throw new NoSuchElementException("No Service found");
            }
            List methods = serviceDescriptor.getMethods();
            return methods.stream().filter(method -> method.getName().equals(config.getMethod())).findFirst().orElseThrow(() -> new NoSuchElementException("No Method found"));
        }

        private ManagedChannel createChannel() {
            URI requestURI = ((Route)this.exchange.getAttributes().get(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR)).getUri();
            return this.createChannelChannel(requestURI.getHost(), requestURI.getPort());
        }

        private Function<JsonNode, DynamicMessage> callGRPCServer() {
            return jsonRequest -> {
                try {
                    byte[] request = this.objectWriter.writeValueAsBytes(jsonRequest);
                    return (DynamicMessage)ClientCalls.blockingUnaryCall(this.clientCall, (Object)DynamicMessage.parseFrom((Descriptors.Descriptor)this.descriptor, (byte[])request));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        private Function<DynamicMessage, Object> serialiseGRPCResponse() {
            return gRPCResponse -> {
                try {
                    return this.objectReader.readValue(gRPCResponse.toByteArray());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        private Flux<JsonNode> deserializeJSONRequest() {
            return this.exchange.getRequest().getBody().mapNotNull(dataBufferBody -> {
                if (dataBufferBody.capacity() == 0) {
                    return this.objectNode;
                }
                ResolvableType targetType = ResolvableType.forType(JsonNode.class);
                return new Jackson2JsonDecoder().decode(dataBufferBody, targetType, null, null);
            }).cast(JsonNode.class);
        }

        private Function<Object, DataBuffer> wrapGRPCResponse() {
            return jsonResponse -> {
                try {
                    return new NettyDataBufferFactory((ByteBufAllocator)new PooledByteBufAllocator()).wrap(Objects.requireNonNull(new ObjectMapper().writeValueAsBytes(jsonResponse)));
                }
                catch (JsonProcessingException e) {
                    return new NettyDataBufferFactory((ByteBufAllocator)new PooledByteBufAllocator()).allocateBuffer();
                }
            };
        }

        private ManagedChannel createChannelChannel(String host, int port) {
            NettyChannelBuilder nettyChannelBuilder = NettyChannelBuilder.forAddress((String)host, (int)port);
            try {
                return JsonToGrpcGatewayFilterFactory.this.grpcSslConfigurer.configureSsl(nettyChannelBuilder);
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

