/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.core;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.auth.oauth2.UserCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.GcpScope;
import org.springframework.core.io.Resource;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultCredentialsProvider
implements CredentialsProvider {
    private static final Log LOGGER = LogFactory.getLog(DefaultCredentialsProvider.class);
    private static final String DEFAULT_SCOPES_PLACEHOLDER = "DEFAULT_SCOPES";
    private static final List<String> CREDENTIALS_SCOPES_LIST = Collections.unmodifiableList(Arrays.stream(GcpScope.values()).map(GcpScope::getUrl).collect(Collectors.toList()));
    private CredentialsProvider wrappedCredentialsProvider;

    public Credentials getCredentials() throws IOException {
        return this.wrappedCredentialsProvider.getCredentials();
    }

    public DefaultCredentialsProvider(CredentialsSupplier credentialsSupplier) throws IOException {
        List<String> scopes = DefaultCredentialsProvider.resolveScopes(credentialsSupplier.getCredentials().getScopes());
        Resource providedLocation = credentialsSupplier.getCredentials().getLocation();
        String encodedKey = credentialsSupplier.getCredentials().getEncodedKey();
        this.wrappedCredentialsProvider = !StringUtils.isEmpty((Object)providedLocation) ? FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)providedLocation.getInputStream()).createScoped(scopes)) : (!StringUtils.isEmpty((Object)encodedKey) ? FixedCredentialsProvider.create((Credentials)GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(encodedKey))).createScoped(scopes)) : GoogleCredentialsProvider.newBuilder().setScopesToApply(scopes).build());
        try {
            Credentials credentials = this.wrappedCredentialsProvider.getCredentials();
            if (LOGGER.isInfoEnabled()) {
                if (credentials instanceof UserCredentials) {
                    LOGGER.info((Object)("Default credentials provider for user " + ((UserCredentials)credentials).getClientId()));
                } else if (credentials instanceof ServiceAccountCredentials) {
                    LOGGER.info((Object)("Default credentials provider for service account " + ((ServiceAccountCredentials)credentials).getClientEmail()));
                } else if (credentials instanceof ComputeEngineCredentials) {
                    LOGGER.info((Object)"Default credentials provider for Google Compute Engine.");
                }
                LOGGER.info((Object)("Scopes in use by default credentials: " + scopes.toString()));
            }
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)"No core credentials are set. Service-specific credentials (e.g., spring.cloud.gcp.pubsub.credentials.*) should be used if your app uses services that require credentials.");
        }
    }

    static List<String> resolveScopes(List<String> scopes) {
        if (!ObjectUtils.isEmpty(scopes)) {
            HashSet resolvedScopes = new HashSet();
            scopes.forEach(scope -> {
                if (DEFAULT_SCOPES_PLACEHOLDER.equals(scope)) {
                    resolvedScopes.addAll(CREDENTIALS_SCOPES_LIST);
                } else {
                    resolvedScopes.add(scope);
                }
            });
            return Collections.unmodifiableList(new ArrayList(resolvedScopes));
        }
        return CREDENTIALS_SCOPES_LIST;
    }
}

