/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.core;

import com.google.cloud.MetadataConfig;
import com.google.cloud.ServiceOptions;
import org.springframework.cloud.gcp.core.GcpEnvironment;
import org.springframework.cloud.gcp.core.GcpEnvironmentProvider;

public class DefaultGcpEnvironmentProvider
implements GcpEnvironmentProvider {
    @Override
    public GcpEnvironment getCurrentEnvironment() {
        if (System.getenv("GAE_INSTANCE") != null) {
            return GcpEnvironment.APP_ENGINE_FLEXIBLE;
        }
        if (System.getenv("KUBERNETES_SERVICE_HOST") != null) {
            return GcpEnvironment.KUBERNETES_ENGINE;
        }
        if (ServiceOptions.getAppEngineAppId() != null) {
            return GcpEnvironment.APP_ENGINE_STANDARD;
        }
        if (MetadataConfig.getInstanceId() != null) {
            return GcpEnvironment.COMPUTE_ENGINE;
        }
        return GcpEnvironment.UNKNOWN;
    }
}

