/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.core.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public final class MapBuilder<K, V> {
    private final Map<K, V> map = new HashMap();

    public MapBuilder<K, V> put(K key, V value) {
        Assert.notNull(key, (String)"Map key cannot be null.");
        Assert.notNull(value, (String)"Map value cannot be null.");
        Assert.isNull(this.map.get(key), (String)"Duplicate keys not allowed.");
        this.map.put(key, value);
        return this;
    }

    public Map<K, V> build() {
        return Collections.unmodifiableMap(this.map);
    }

    public Map<K, V> buildModifiable() {
        return this.map;
    }
}

