/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.kubernetes.commons.config.AbstractConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.kubernetes.config")
public class ConfigMapConfigProperties
extends AbstractConfigProperties {
    private static final Log LOG = LogFactory.getLog(ConfigMapConfigProperties.class);
    private boolean enableApi = true;
    private List<String> paths = Collections.emptyList();
    private List<Source> sources = Collections.emptyList();

    public boolean isEnableApi() {
        return this.enableApi;
    }

    public void setEnableApi(boolean enableApi) {
        this.enableApi = enableApi;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public List<NormalizedSource> determineSources() {
        if (this.sources.isEmpty()) {
            if (this.useNameAsPrefix) {
                LOG.warn((Object)"'spring.cloud.kubernetes.config.useNameAsPrefix' is set to 'true', but 'spring.cloud.kubernetes.config.sources' is empty; as such will default 'useNameAsPrefix' to 'false'");
            }
            return Collections.singletonList(new NormalizedSource(this.name, this.namespace, ""));
        }
        return this.sources.stream().map(s -> s.normalize(this.name, this.namespace, this.useNameAsPrefix)).collect(Collectors.toList());
    }

    @Override
    public String getConfigurationTarget() {
        return "Config Map";
    }

    public static class NormalizedSource {
        private final String name;
        private final String namespace;
        private final String prefix;

        @Deprecated
        NormalizedSource(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
            this.prefix = "";
        }

        NormalizedSource(String name, String namespace, String prefix) {
            this.name = name;
            this.namespace = namespace;
            this.prefix = Objects.requireNonNull(prefix);
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String toString() {
            return "{ config-map name : '" + this.name + "', namespace : '" + this.namespace + "', prefix : '" + this.prefix + "' }";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NormalizedSource other = (NormalizedSource)o;
            return Objects.equals(this.name, other.name) && Objects.equals(this.namespace, other.namespace);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.namespace);
        }
    }

    public static class Source {
        private String name;
        private String namespace;
        private Boolean useNameAsPrefix;
        private String explicitPrefix;

        public Source() {
        }

        public Source(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public Boolean isUseNameAsPrefix() {
            return this.useNameAsPrefix;
        }

        public void setUseNameAsPrefix(Boolean useNameAsPrefix) {
            this.useNameAsPrefix = useNameAsPrefix;
        }

        public String getExplicitPrefix() {
            return this.explicitPrefix;
        }

        public void setExplicitPrefix(String explicitPrefix) {
            this.explicitPrefix = explicitPrefix;
        }

        public boolean isEmpty() {
            return !StringUtils.hasLength((String)this.name) && !StringUtils.hasLength((String)this.namespace);
        }

        @Deprecated
        public NormalizedSource normalize(String defaultName, String defaultNamespace) {
            String normalizedName = StringUtils.hasLength((String)this.name) ? this.name : defaultName;
            String normalizedNamespace = StringUtils.hasLength((String)this.namespace) ? this.namespace : defaultNamespace;
            return new NormalizedSource(normalizedName, normalizedNamespace, "");
        }

        public NormalizedSource normalize(String defaultName, String defaultNamespace, boolean defaultUseNameAsPrefix) {
            String normalizedName = StringUtils.hasLength((String)this.name) ? this.name : defaultName;
            String normalizedNamespace = StringUtils.hasLength((String)this.namespace) ? this.namespace : defaultNamespace;
            String prefix = ConfigUtils.findPrefix(this.explicitPrefix, this.useNameAsPrefix, defaultUseNameAsPrefix, normalizedName);
            return new NormalizedSource(normalizedName, normalizedNamespace, prefix);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Source other = (Source)o;
            return Objects.equals(this.name, other.name) && Objects.equals(this.namespace, other.namespace);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.namespace);
        }
    }
}

