/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import java.time.Duration;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.task.TaskSchedulerBuilder;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public class PollingSecretsChangeDetector
extends ConfigurationChangeDetector {
    protected Log log = LogFactory.getLog(this.getClass());
    private final PropertySourceLocator propertySourceLocator;
    private Class propertySourceClass;
    private TaskScheduler taskExecutor;
    private Duration period = Duration.ofMillis(1500L);

    @Deprecated
    public PollingSecretsChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Class propertySourceClass, PropertySourceLocator propertySourceLocator) {
        super((ConfigurableEnvironment)environment, properties, strategy);
        this.propertySourceClass = propertySourceClass;
        this.propertySourceLocator = propertySourceLocator;
        this.taskExecutor = new TaskSchedulerBuilder().build();
    }

    public PollingSecretsChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Class propertySourceClass, PropertySourceLocator propertySourceLocator, TaskScheduler taskExecutor) {
        super((ConfigurableEnvironment)environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.propertySourceClass = propertySourceClass;
        this.taskExecutor = taskExecutor;
        this.period = properties.getPeriod();
    }

    @PostConstruct
    public void init() {
        this.log.info((Object)"Kubernetes polling secrets change detector activated");
        PeriodicTrigger trigger = new PeriodicTrigger(this.period.toMillis());
        trigger.setInitialDelay(this.period.toMillis());
        this.taskExecutor.schedule(this::executeCycle, (Trigger)trigger);
    }

    public void executeCycle() {
        boolean changedSecrets = false;
        if (this.properties.isMonitoringSecrets()) {
            List<MapPropertySource> currentSecretSources;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Polling for changes in secrets");
            }
            if ((currentSecretSources = this.locateMapPropertySources(this.propertySourceLocator, (Environment)this.environment)) != null && !currentSecretSources.isEmpty()) {
                List propertySources = this.findPropertySources(this.propertySourceClass);
                changedSecrets = this.changed(currentSecretSources, propertySources);
            }
        }
        if (changedSecrets) {
            this.log.info((Object)"Detected change in secrets");
            this.reloadProperties();
        }
    }
}

