/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.PropertySourceUtils;
import org.springframework.cloud.kubernetes.commons.config.SourceData;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class SourceDataEntriesProcessor
extends MapPropertySource {
    private static final Log LOG = LogFactory.getLog(SourceDataEntriesProcessor.class);

    public SourceDataEntriesProcessor(SourceData sourceData) {
        super(sourceData.sourceName(), sourceData.sourceData());
    }

    public static Map<String, Object> processAllEntries(Map<String, String> input, Environment environment) {
        Set<Map.Entry<String, String>> entrySet = input.entrySet();
        if (entrySet.size() == 1) {
            Map.Entry<String, String> singleEntry = entrySet.iterator().next();
            String propertyName = singleEntry.getKey();
            String propertyValue = singleEntry.getValue();
            if (propertyName.endsWith(".yml") || propertyName.endsWith(".yaml")) {
                LOG.debug((Object)("The single property with name: [" + propertyName + "] will be treated as a yaml file"));
                return PropertySourceUtils.yamlParserGenerator(environment).andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(propertyValue);
            }
            if (propertyName.endsWith(".properties")) {
                LOG.debug((Object)("The single property with name: [" + propertyName + "] will be treated as a properties file"));
                return PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(propertyValue);
            }
        }
        return SourceDataEntriesProcessor.defaultProcessAllEntries(input, environment);
    }

    private static Map<String, Object> defaultProcessAllEntries(Map<String, String> input, Environment environment) {
        String applicationName = ConfigUtils.getApplicationName(environment, "", "");
        String[] activeProfiles = environment.getActiveProfiles();
        Set fileNames = Stream.concat(Stream.of(applicationName), Arrays.stream(activeProfiles).map(profile -> applicationName + "-" + profile)).collect(Collectors.toSet());
        return input.entrySet().stream().map(e -> SourceDataEntriesProcessor.extractProperties((String)e.getKey(), (String)e.getValue(), fileNames, environment)).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, PropertySourceUtils.throwingMerger(), HashMap::new));
    }

    private static Map<String, Object> extractProperties(String resourceName, String content, Set<String> fileNames, Environment environment) {
        if (resourceName.endsWith(".yml") || resourceName.endsWith(".yaml") || resourceName.endsWith(".properties")) {
            if (fileNames.contains(resourceName.split("\\.", 2)[0])) {
                if (resourceName.endsWith(".properties")) {
                    LOG.debug((Object)("entry : " + resourceName + " will be treated as a single properties file"));
                    return PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(content);
                }
                LOG.debug((Object)("entry : " + resourceName + " will be treated as a single yml/yaml file"));
                return PropertySourceUtils.yamlParserGenerator(environment).andThen(PropertySourceUtils.PROPERTIES_TO_MAP).apply(content);
            }
            LOG.warn((Object)("entry : " + resourceName + " will be skipped"));
            return Collections.emptyMap();
        }
        return Collections.singletonMap(resourceName, content);
    }
}

