/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Optional;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSourceType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class NormalizedSource {
    private final String namespace;
    private final String name;
    private final boolean failFast;

    protected NormalizedSource(String name, String namespace, boolean failFast) {
        this.name = name;
        this.namespace = namespace;
        this.failFast = failFast;
    }

    public final Optional<String> namespace() {
        return Optional.ofNullable(this.namespace);
    }

    public final Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    public final boolean failFast() {
        return this.failFast;
    }

    public abstract NormalizedSourceType type();

    public abstract String target();

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

