/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.cloud.kubernetes.PodUtils;

public class KubernetesInfoContributor
implements InfoContributor {
    private static final Log LOG = LogFactory.getLog(KubernetesInfoContributor.class);
    private PodUtils utils;

    public KubernetesInfoContributor(PodUtils utils) {
        this.utils = utils;
    }

    public void contribute(Info.Builder builder) {
        try {
            Pod current = this.utils.currentPod().get();
            HashMap<String, Object> details = new HashMap<String, Object>();
            if (current != null) {
                details.put("inside", true);
                details.put("namespace", current.getMetadata().getNamespace());
                details.put("podName", current.getMetadata().getName());
                details.put("podIp", current.getStatus().getPodIP());
                details.put("serviceAccount", current.getSpec().getServiceAccountName());
                details.put("nodeName", current.getSpec().getNodeName());
                details.put("hostIp", current.getStatus().getHostIP());
            } else {
                details.put("inside", false);
            }
            builder.withDetail("kubernetes", details);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get pod details", (Throwable)e);
        }
    }
}

