/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.profile;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.function.Supplier;
import org.springframework.cloud.kubernetes.LazilyInstantiate;
import org.springframework.cloud.kubernetes.StandardPodUtils;
import org.springframework.cloud.kubernetes.profile.KubernetesProfileApplicationListener;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;

public class KubernetesApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    private static final int ORDER = 100;
    private final Supplier<KubernetesProfileApplicationListener> listenerSupplier;

    public KubernetesApplicationContextInitializer() {
        this(LazilyInstantiate.using(() -> new KubernetesProfileApplicationListener(new StandardPodUtils((KubernetesClient)new DefaultKubernetesClient()))));
    }

    public KubernetesApplicationContextInitializer(Supplier<KubernetesProfileApplicationListener> listenerSupplier) {
        this.listenerSupplier = listenerSupplier;
    }

    public int getOrder() {
        return 100;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.listenerSupplier.get().addKubernetesProfile(applicationContext.getEnvironment());
    }
}

