/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.kubernetes.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.KubernetesHealthIndicator;
import org.springframework.cloud.kubernetes.KubernetesInfoContributor;
import org.springframework.cloud.kubernetes.PodUtils;
import org.springframework.cloud.kubernetes.StandardPodUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={KubernetesClientProperties.class})
public class KubernetesAutoConfiguration {
    private static final Log LOG = LogFactory.getLog(KubernetesAutoConfiguration.class);

    private static <D> D or(D dis, D dat) {
        if (dis != null) {
            return dis;
        }
        return dat;
    }

    private static Integer orDurationInt(Duration dis, Integer dat) {
        if (dis != null) {
            return (int)dis.toMillis();
        }
        return dat;
    }

    private static Long orDurationLong(Duration dis, Long dat) {
        if (dis != null) {
            return dis.toMillis();
        }
        return dat;
    }

    @Bean
    @ConditionalOnMissingBean(value={Config.class})
    public Config kubernetesClientConfig(KubernetesClientProperties kubernetesClientProperties) {
        Config base = Config.autoConfigure(null);
        Config properties = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(base).withMasterUrl(KubernetesAutoConfiguration.or(kubernetesClientProperties.getMasterUrl(), base.getMasterUrl()))).withApiVersion(KubernetesAutoConfiguration.or(kubernetesClientProperties.getApiVersion(), base.getApiVersion()))).withNamespace(KubernetesAutoConfiguration.or(kubernetesClientProperties.getNamespace(), base.getNamespace()))).withUsername(KubernetesAutoConfiguration.or(kubernetesClientProperties.getUsername(), base.getUsername()))).withPassword(KubernetesAutoConfiguration.or(kubernetesClientProperties.getPassword(), base.getPassword()))).withCaCertFile(KubernetesAutoConfiguration.or(kubernetesClientProperties.getCaCertFile(), base.getCaCertFile()))).withCaCertData(KubernetesAutoConfiguration.or(kubernetesClientProperties.getCaCertData(), base.getCaCertData()))).withClientKeyFile(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientKeyFile(), base.getClientKeyFile()))).withClientKeyData(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientKeyData(), base.getClientKeyData()))).withClientCertFile(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientCertFile(), base.getClientCertFile()))).withClientCertData(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientCertData(), base.getClientCertData()))).withClientKeyAlgo(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientKeyAlgo(), base.getClientKeyAlgo()))).withClientKeyPassphrase(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientKeyPassphrase(), base.getClientKeyPassphrase()))).withConnectionTimeout(KubernetesAutoConfiguration.orDurationInt(kubernetesClientProperties.getConnectionTimeout(), base.getConnectionTimeout()).intValue())).withRequestTimeout(KubernetesAutoConfiguration.orDurationInt(kubernetesClientProperties.getRequestTimeout(), base.getRequestTimeout()).intValue())).withRollingTimeout(KubernetesAutoConfiguration.orDurationLong(kubernetesClientProperties.getRollingTimeout(), base.getRollingTimeout()).longValue())).withTrustCerts(KubernetesAutoConfiguration.or(kubernetesClientProperties.isTrustCerts(), base.isTrustCerts()).booleanValue())).withHttpProxy(KubernetesAutoConfiguration.or(kubernetesClientProperties.getHttpProxy(), base.getHttpProxy()))).withHttpsProxy(KubernetesAutoConfiguration.or(kubernetesClientProperties.getHttpsProxy(), base.getHttpsProxy()))).withProxyUsername(KubernetesAutoConfiguration.or(kubernetesClientProperties.getProxyUsername(), base.getProxyUsername()))).withPassword(KubernetesAutoConfiguration.or(kubernetesClientProperties.getProxyPassword(), base.getProxyPassword()))).withNoProxy(KubernetesAutoConfiguration.or(kubernetesClientProperties.getNoProxy(), base.getNoProxy()))).build();
        if (properties.getNamespace() == null || properties.getNamespace().isEmpty()) {
            LOG.warn((Object)"No namespace has been detected. Please specify KUBERNETES_NAMESPACE env var, or use a later kubernetes version (1.3 or later)");
        }
        return properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesClient kubernetesClient(Config config) {
        return new DefaultKubernetesClient(config);
    }

    @Bean
    @ConditionalOnMissingBean
    public StandardPodUtils kubernetesPodUtils(KubernetesClient client) {
        return new StandardPodUtils(client);
    }

    @Configuration
    @ConditionalOnClass(value={HealthIndicator.class})
    protected static class KubernetesActuatorConfiguration {
        protected KubernetesActuatorConfiguration() {
        }

        @Bean
        @ConditionalOnEnabledHealthIndicator(value="kubernetes")
        public KubernetesHealthIndicator kubernetesHealthIndicator(PodUtils podUtils) {
            return new KubernetesHealthIndicator(podUtils);
        }

        @Bean
        public KubernetesInfoContributor kubernetesInfoContributor(PodUtils podUtils) {
            return new KubernetesInfoContributor(podUtils);
        }
    }
}

