/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.profile;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.kubernetes.StandardPodUtils;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class KubernetesProfileEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Log LOG = LogFactory.getLog(KubernetesProfileEnvironmentPostProcessor.class);
    private static final int ORDER = -2147483639;
    private static final String KUBERNETES_PROFILE = "kubernetes";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String enabledStr = environment.getProperty("spring.cloud.kubernetes.enabled", "true");
        if ("false".equals(enabledStr.toLowerCase())) {
            return;
        }
        StandardPodUtils podUtils = new StandardPodUtils((KubernetesClient)new DefaultKubernetesClient());
        if (podUtils.isInsideKubernetes().booleanValue()) {
            if (this.hasKubernetesProfile((Environment)environment)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"'kubernetes' already in list of active profiles");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Adding 'kubernetes' to list of active profiles");
                }
                environment.addActiveProfile(KUBERNETES_PROFILE);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.warn((Object)"Not running inside kubernetes. Skipping 'kubernetes' profile activation.");
        }
    }

    private boolean hasKubernetesProfile(Environment environment) {
        for (String activeProfile : environment.getActiveProfiles()) {
            if (!KUBERNETES_PROFILE.equalsIgnoreCase(activeProfile)) continue;
            return true;
        }
        return false;
    }

    public int getOrder() {
        return -2147483639;
    }
}

