/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cache.CacheManager;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheManager;
import org.springframework.cloud.loadbalancer.config.LoadBalancerZoneConfig;
import org.springframework.cloud.loadbalancer.core.CachingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.DiscoveryClientServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.HealthCheckServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.RequestBasedStickySessionServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.RetryAwareServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.SameInstancePreferenceServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ZonePreferenceServiceInstanceListSupplier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ServiceInstanceListSupplierBuilder {
    private static final Log LOG = LogFactory.getLog(ServiceInstanceListSupplierBuilder.class);
    private Creator baseCreator;
    private DelegateCreator cachingCreator;
    private final List<DelegateCreator> creators = new ArrayList<DelegateCreator>();

    ServiceInstanceListSupplierBuilder() {
    }

    public ServiceInstanceListSupplierBuilder withBlockingDiscoveryClient() {
        if (this.baseCreator != null && LOG.isWarnEnabled()) {
            LOG.warn((Object)"Overriding a previously set baseCreator with a blocking DiscoveryClient baseCreator.");
        }
        this.baseCreator = context -> {
            DiscoveryClient discoveryClient = (DiscoveryClient)context.getBean(DiscoveryClient.class);
            return new DiscoveryClientServiceInstanceListSupplier(discoveryClient, (Environment)context.getEnvironment());
        };
        return this;
    }

    public ServiceInstanceListSupplierBuilder withDiscoveryClient() {
        if (this.baseCreator != null && LOG.isWarnEnabled()) {
            LOG.warn((Object)"Overriding a previously set baseCreator with a ReactiveDiscoveryClient baseCreator.");
        }
        this.baseCreator = context -> {
            ReactiveDiscoveryClient discoveryClient = (ReactiveDiscoveryClient)context.getBean(ReactiveDiscoveryClient.class);
            return new DiscoveryClientServiceInstanceListSupplier(discoveryClient, (Environment)context.getEnvironment());
        };
        return this;
    }

    public ServiceInstanceListSupplierBuilder withBase(ServiceInstanceListSupplier supplier) {
        this.baseCreator = context -> supplier;
        return this;
    }

    public ServiceInstanceListSupplierBuilder withHealthChecks() {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerProperties properties = (LoadBalancerProperties)context.getBean(LoadBalancerProperties.class);
            WebClient.Builder webClient = (WebClient.Builder)context.getBean(WebClient.Builder.class);
            return this.healthCheckServiceInstanceListSupplier(webClient.build(), (ServiceInstanceListSupplier)delegate, properties);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withHealthChecks(WebClient webClient) {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerProperties properties = (LoadBalancerProperties)context.getBean(LoadBalancerProperties.class);
            return this.healthCheckServiceInstanceListSupplier(webClient, (ServiceInstanceListSupplier)delegate, properties);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withSameInstancePreference() {
        DelegateCreator creator = (context, delegate) -> new SameInstancePreferenceServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate);
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withBlockingHealthChecks() {
        DelegateCreator creator = (context, delegate) -> {
            RestTemplate restTemplate = (RestTemplate)context.getBean(RestTemplate.class);
            LoadBalancerProperties properties = (LoadBalancerProperties)context.getBean(LoadBalancerProperties.class);
            return this.blockingHealthCheckServiceInstanceListSupplier(restTemplate, (ServiceInstanceListSupplier)delegate, properties);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withBlockingHealthChecks(RestTemplate restTemplate) {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerProperties properties = (LoadBalancerProperties)context.getBean(LoadBalancerProperties.class);
            return this.blockingHealthCheckServiceInstanceListSupplier(restTemplate, (ServiceInstanceListSupplier)delegate, properties);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withZonePreference() {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerZoneConfig zoneConfig = (LoadBalancerZoneConfig)context.getBean(LoadBalancerZoneConfig.class);
            return new ZonePreferenceServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, zoneConfig);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withRequestBasedStickySession() {
        DelegateCreator creator = (context, delegate) -> {
            LoadBalancerProperties properties = (LoadBalancerProperties)context.getBean(LoadBalancerProperties.class);
            return new RequestBasedStickySessionServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, properties);
        };
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplierBuilder withCaching() {
        if (this.cachingCreator != null && LOG.isWarnEnabled()) {
            LOG.warn((Object)"Overriding a previously set cachingCreator with a CachingServiceInstanceListSupplier-based cachingCreator.");
        }
        this.cachingCreator = (context, delegate) -> {
            ObjectProvider cacheManagerProvider = context.getBeanProvider(LoadBalancerCacheManager.class);
            if (cacheManagerProvider.getIfAvailable() != null) {
                return new CachingServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate, (CacheManager)cacheManagerProvider.getIfAvailable());
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"LoadBalancerCacheManager not available, returning delegate without caching.");
            }
            return delegate;
        };
        return this;
    }

    public ServiceInstanceListSupplierBuilder withRetryAwareness() {
        DelegateCreator creator = (context, delegate) -> new RetryAwareServiceInstanceListSupplier((ServiceInstanceListSupplier)delegate);
        this.creators.add(creator);
        return this;
    }

    public ServiceInstanceListSupplier build(ConfigurableApplicationContext context) {
        Assert.notNull((Object)this.baseCreator, (String)"A baseCreator must not be null");
        ServiceInstanceListSupplier supplier = (ServiceInstanceListSupplier)this.baseCreator.apply(context);
        for (DelegateCreator creator : this.creators) {
            supplier = (ServiceInstanceListSupplier)creator.apply(context, supplier);
        }
        if (this.cachingCreator != null) {
            supplier = (ServiceInstanceListSupplier)this.cachingCreator.apply(context, supplier);
        }
        return supplier;
    }

    private ServiceInstanceListSupplier healthCheckServiceInstanceListSupplier(WebClient webClient, ServiceInstanceListSupplier delegate, LoadBalancerProperties properties) {
        return new HealthCheckServiceInstanceListSupplier(delegate, properties.getHealthCheck(), (serviceInstance, healthCheckPath) -> webClient.get().uri(UriComponentsBuilder.fromUri((URI)serviceInstance.getUri()).path(healthCheckPath).build().toUri()).exchange().flatMap(clientResponse -> clientResponse.releaseBody().thenReturn((Object)(HttpStatus.OK.value() == clientResponse.rawStatusCode() ? 1 : 0))));
    }

    private ServiceInstanceListSupplier blockingHealthCheckServiceInstanceListSupplier(RestTemplate restTemplate, ServiceInstanceListSupplier delegate, LoadBalancerProperties properties) {
        return new HealthCheckServiceInstanceListSupplier(delegate, properties.getHealthCheck(), (serviceInstance, healthCheckPath) -> Mono.defer(() -> {
            URI uri = UriComponentsBuilder.fromUri((URI)serviceInstance.getUri()).path(healthCheckPath).build().toUri();
            try {
                return Mono.just((Object)HttpStatus.OK.equals((Object)restTemplate.getForEntity(uri, Void.class).getStatusCode()));
            }
            catch (Exception ignored) {
                return Mono.just((Object)false);
            }
        }));
    }

    public static interface DelegateCreator
    extends BiFunction<ConfigurableApplicationContext, ServiceInstanceListSupplier, ServiceInstanceListSupplier> {
    }

    public static interface Creator
    extends Function<ConfigurableApplicationContext, ServiceInstanceListSupplier> {
    }
}

