/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.ribbon.LoadBalancingTarget;
import feign.slf4j.Slf4jLogger;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class FeignClientFactoryBean
implements FactoryBean<Object>,
InitializingBean {
    private Class<?> type;
    private String name;
    private String url;
    @Autowired
    private Decoder decoder;
    @Autowired
    private Encoder encoder;
    @Autowired
    private Logger logger;
    @Autowired
    private Contract contract;
    @Autowired(required=false)
    private Logger.Level logLevel;
    @Autowired(required=false)
    private Retryer retryer;
    @Autowired(required=false)
    private ErrorDecoder errorDecoder;
    @Autowired(required=false)
    private Request.Options options;
    @Autowired(required=false)
    private Client ribbonClient;
    @Autowired(required=false)
    private List<RequestInterceptor> requestInterceptors;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.hasText((String)this.name)) {
            Assert.state((!StringUtils.hasText((String)this.url) ? 1 : 0) != 0, (String)"Either value or url can be specified, but not both");
        }
    }

    protected Feign.Builder feign() {
        Feign.Builder builder = Feign.builder().logger(this.logger).encoder(this.encoder).decoder(this.decoder).contract(this.contract);
        if (this.logLevel != null) {
            builder.logLevel(this.logLevel);
        }
        if (this.retryer != null) {
            builder.retryer(this.retryer);
        }
        if (this.errorDecoder != null) {
            builder.errorDecoder(this.errorDecoder);
        }
        if (this.options != null) {
            builder.options(this.options);
        }
        if (this.requestInterceptors != null) {
            builder.requestInterceptors(this.requestInterceptors);
        }
        return builder;
    }

    protected <T> T loadBalance(Feign.Builder builder, Class<T> type, String schemeName) {
        builder.logger((Logger)new Slf4jLogger(type));
        if (this.ribbonClient != null) {
            return (T)builder.client(this.ribbonClient).target(type, schemeName);
        }
        return (T)builder.target((Target)LoadBalancingTarget.create(type, (String)schemeName));
    }

    public Object getObject() throws Exception {
        if (StringUtils.hasText((String)this.name) && !this.name.startsWith("http")) {
            this.name = "http://" + this.name;
        }
        if (StringUtils.hasText((String)this.name)) {
            return this.loadBalance(this.feign(), this.type, this.name);
        }
        if (StringUtils.hasText((String)this.url) && !this.url.startsWith("http")) {
            this.url = "http://" + this.url;
        }
        return this.feign().target(this.type, this.url);
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    public Encoder getEncoder() {
        return this.encoder;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Contract getContract() {
        return this.contract;
    }

    public Logger.Level getLogLevel() {
        return this.logLevel;
    }

    public Retryer getRetryer() {
        return this.retryer;
    }

    public ErrorDecoder getErrorDecoder() {
        return this.errorDecoder;
    }

    public Request.Options getOptions() {
        return this.options;
    }

    public Client getRibbonClient() {
        return this.ribbonClient;
    }

    public List<RequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDecoder(Decoder decoder) {
        this.decoder = decoder;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    public void setLogLevel(Logger.Level logLevel) {
        this.logLevel = logLevel;
    }

    public void setRetryer(Retryer retryer) {
        this.retryer = retryer;
    }

    public void setErrorDecoder(ErrorDecoder errorDecoder) {
        this.errorDecoder = errorDecoder;
    }

    public void setOptions(Request.Options options) {
        this.options = options;
    }

    public void setRibbonClient(Client ribbonClient) {
        this.ribbonClient = ribbonClient;
    }

    public void setRequestInterceptors(List<RequestInterceptor> requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }

    public String toString() {
        return "FeignClientFactoryBean(type=" + this.getType() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", decoder=" + this.getDecoder() + ", encoder=" + this.getEncoder() + ", logger=" + this.getLogger() + ", contract=" + this.getContract() + ", logLevel=" + this.getLogLevel() + ", retryer=" + this.getRetryer() + ", errorDecoder=" + this.getErrorDecoder() + ", options=" + this.getOptions() + ", ribbonClient=" + this.getRibbonClient() + ", requestInterceptors=" + this.getRequestInterceptors() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeignClientFactoryBean)) {
            return false;
        }
        FeignClientFactoryBean other = (FeignClientFactoryBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Decoder this$decoder = this.getDecoder();
        Decoder other$decoder = other.getDecoder();
        if (this$decoder == null ? other$decoder != null : !this$decoder.equals(other$decoder)) {
            return false;
        }
        Encoder this$encoder = this.getEncoder();
        Encoder other$encoder = other.getEncoder();
        if (this$encoder == null ? other$encoder != null : !this$encoder.equals(other$encoder)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        Contract this$contract = this.getContract();
        Contract other$contract = other.getContract();
        if (this$contract == null ? other$contract != null : !this$contract.equals(other$contract)) {
            return false;
        }
        Logger.Level this$logLevel = this.getLogLevel();
        Logger.Level other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        Retryer this$retryer = this.getRetryer();
        Retryer other$retryer = other.getRetryer();
        if (this$retryer == null ? other$retryer != null : !this$retryer.equals(other$retryer)) {
            return false;
        }
        ErrorDecoder this$errorDecoder = this.getErrorDecoder();
        ErrorDecoder other$errorDecoder = other.getErrorDecoder();
        if (this$errorDecoder == null ? other$errorDecoder != null : !this$errorDecoder.equals(other$errorDecoder)) {
            return false;
        }
        Request.Options this$options = this.getOptions();
        Request.Options other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) {
            return false;
        }
        Client this$ribbonClient = this.getRibbonClient();
        Client other$ribbonClient = other.getRibbonClient();
        if (this$ribbonClient == null ? other$ribbonClient != null : !this$ribbonClient.equals(other$ribbonClient)) {
            return false;
        }
        List<RequestInterceptor> this$requestInterceptors = this.getRequestInterceptors();
        List<RequestInterceptor> other$requestInterceptors = other.getRequestInterceptors();
        return !(this$requestInterceptors == null ? other$requestInterceptors != null : !((Object)this$requestInterceptors).equals(other$requestInterceptors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeignClientFactoryBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 0 : $url.hashCode());
        Decoder $decoder = this.getDecoder();
        result = result * 59 + ($decoder == null ? 0 : $decoder.hashCode());
        Encoder $encoder = this.getEncoder();
        result = result * 59 + ($encoder == null ? 0 : $encoder.hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 0 : $logger.hashCode());
        Contract $contract = this.getContract();
        result = result * 59 + ($contract == null ? 0 : $contract.hashCode());
        Logger.Level $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 0 : $logLevel.hashCode());
        Retryer $retryer = this.getRetryer();
        result = result * 59 + ($retryer == null ? 0 : $retryer.hashCode());
        ErrorDecoder $errorDecoder = this.getErrorDecoder();
        result = result * 59 + ($errorDecoder == null ? 0 : $errorDecoder.hashCode());
        Request.Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 0 : $options.hashCode());
        Client $ribbonClient = this.getRibbonClient();
        result = result * 59 + ($ribbonClient == null ? 0 : $ribbonClient.hashCode());
        List<RequestInterceptor> $requestInterceptors = this.getRequestInterceptors();
        result = result * 59 + ($requestInterceptors == null ? 0 : ((Object)$requestInterceptors).hashCode());
        return result;
    }
}

