/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.cloud.netflix.feign.FeignClientFactoryBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class FeignClientsRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware {
    private ResourceLoader resourceLoader;
    private ClassLoader classLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Set<String> basePackages = this.getBasePackages(importingClassMetadata);
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(FeignClient.class));
        scanner.setResourceLoader(this.resourceLoader);
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
                Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@FeignClient can only be specified on an interface");
                BeanDefinitionHolder holder = this.createBeanDefinition(annotationMetadata);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
            }
        }
    }

    private BeanDefinitionHolder createBeanDefinition(AnnotationMetadata annotationMetadata) {
        Map attributes = annotationMetadata.getAnnotationAttributes(FeignClient.class.getCanonicalName());
        String className = annotationMetadata.getClassName();
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition(FeignClientFactoryBean.class);
        this.validate(attributes);
        definition.addPropertyValue("url", (Object)this.getUrl(attributes));
        definition.addPropertyValue("name", (Object)this.getServiceId(attributes));
        definition.addPropertyValue("type", (Object)className);
        String beanName = StringUtils.uncapitalize((String)className.substring(className.lastIndexOf(".") + 1));
        return new BeanDefinitionHolder((BeanDefinition)definition.getBeanDefinition(), beanName);
    }

    private void validate(Map<String, Object> attributes) {
        if (StringUtils.hasText((String)((String)attributes.get("value")))) {
            Assert.isTrue((!StringUtils.hasText((String)((String)attributes.get("name"))) ? 1 : 0) != 0, (String)"Either name or value can be specified, but not both");
        }
    }

    private String getServiceId(Map<String, Object> attributes) {
        if (StringUtils.hasText((String)((String)attributes.get("name")))) {
            return (String)attributes.get("name");
        }
        return (String)attributes.get("value");
    }

    private String getUrl(Map<String, Object> attributes) {
        return (String)attributes.get("url");
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                if (beanDefinition.getMetadata().isIndependent()) {
                    if (beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().getInterfaceNames().length == 1 && Annotation.class.getName().equals(beanDefinition.getMetadata().getInterfaceNames()[0])) {
                        try {
                            Class target = ClassUtils.forName((String)beanDefinition.getMetadata().getClassName(), (ClassLoader)FeignClientsRegistrar.this.classLoader);
                            return !target.isAnnotation();
                        }
                        catch (Exception ex) {
                            this.logger.error((Object)("Could not load target class: " + beanDefinition.getMetadata().getClassName()), (Throwable)ex);
                        }
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        String pkg;
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableFeignClients.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        Object[] objectArray = (String[])attributes.get("value");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            pkg = objectArray[n2];
            if (StringUtils.hasText((String)pkg)) {
                basePackages.add(pkg);
            }
            ++n2;
        }
        objectArray = (String[])attributes.get("basePackages");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            pkg = objectArray[n2];
            if (StringUtils.hasText((String)pkg)) {
                basePackages.add(pkg);
            }
            ++n2;
        }
        objectArray = (Class[])attributes.get("basePackageClasses");
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object clazz = objectArray[n2];
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
            ++n2;
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }
}

