/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.ribbon;

import com.netflix.client.ClientException;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import dagger.Lazy;
import feign.Client;
import feign.Request;
import feign.Response;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.springframework.cloud.netflix.feign.ribbon.RibbonLoadBalancer;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.util.ReflectionUtils;

public class FeignRibbonClient
implements Client {
    private Client defaultClient = new Client.Default((Lazy)new LazySSLSocketFactory(), (Lazy)new LazyHostnameVerifier());
    private SpringClientFactory factory;

    public FeignRibbonClient(SpringClientFactory factory) {
        this.factory = factory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        try {
            URI asUri = URI.create(request.url());
            String clientName = asUri.getHost();
            URI uriWithoutSchemeAndPort = URI.create(request.url().replace(String.valueOf(asUri.getScheme()) + "://" + asUri.getHost(), String.valueOf(asUri.getScheme()) + "://"));
            RibbonLoadBalancer.RibbonRequest ribbonRequest = new RibbonLoadBalancer.RibbonRequest(request, uriWithoutSchemeAndPort);
            LBClient client = this.getClient(clientName);
            return ((RibbonLoadBalancer.RibbonResponse)client.getLoadBalancer().executeWithLoadBalancer(ribbonRequest, client.config)).toResponse();
        }
        catch (ClientException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)IOException.class.cast(ex.getCause());
            }
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
            return null;
        }
    }

    private LBClient getClient(String clientName) {
        IClientConfig config = this.factory.getClientConfig(clientName);
        ILoadBalancer lb = this.factory.getLoadBalancer(clientName);
        RibbonLoadBalancer loadBalancer = new RibbonLoadBalancer(this.defaultClient, lb, config);
        return new LBClient(config, loadBalancer);
    }

    public void setDefaultClient(Client defaultClient) {
        this.defaultClient = defaultClient;
    }

    private class LBClient {
        private final IClientConfig config;
        private final RibbonLoadBalancer loadBalancer;

        public IClientConfig getConfig() {
            return this.config;
        }

        public RibbonLoadBalancer getLoadBalancer() {
            return this.loadBalancer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LBClient)) {
                return false;
            }
            LBClient other = (LBClient)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IClientConfig this$config = this.getConfig();
            IClientConfig other$config = other.getConfig();
            if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
                return false;
            }
            RibbonLoadBalancer this$loadBalancer = this.getLoadBalancer();
            RibbonLoadBalancer other$loadBalancer = other.getLoadBalancer();
            return !(this$loadBalancer == null ? other$loadBalancer != null : !((Object)((Object)this$loadBalancer)).equals((Object)other$loadBalancer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LBClient;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IClientConfig $config = this.getConfig();
            result = result * 59 + ($config == null ? 0 : $config.hashCode());
            RibbonLoadBalancer $loadBalancer = this.getLoadBalancer();
            result = result * 59 + ($loadBalancer == null ? 0 : ((Object)((Object)$loadBalancer)).hashCode());
            return result;
        }

        public String toString() {
            return "FeignRibbonClient.LBClient(config=" + this.getConfig() + ", loadBalancer=" + (Object)((Object)this.getLoadBalancer()) + ")";
        }

        @ConstructorProperties(value={"config", "loadBalancer"})
        public LBClient(IClientConfig config, RibbonLoadBalancer loadBalancer) {
            this.config = config;
            this.loadBalancer = loadBalancer;
        }
    }

    private static class LazyHostnameVerifier
    implements Lazy<HostnameVerifier> {
        private LazyHostnameVerifier() {
        }

        public HostnameVerifier get() {
            return HttpsURLConnection.getDefaultHostnameVerifier();
        }
    }

    private static class LazySSLSocketFactory
    implements Lazy<SSLSocketFactory> {
        private LazySSLSocketFactory() {
        }

        public SSLSocketFactory get() {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
    }
}

