/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign.support;

import feign.Contract;
import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class SpringMvcContract
extends Contract.BaseContract {
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        RequestMapping mapping = (RequestMapping)RequestMapping.class.cast(methodAnnotation);
        if (mapping != null) {
            String clientProduces;
            String clientAccepts;
            this.checkOne(method, mapping.method(), "method");
            data.template().method(mapping.method()[0].name());
            this.checkOne(method, mapping.value(), "value");
            String methodAnnotationValue = mapping.value()[0];
            String pathValue = Util.emptyToNull((String)methodAnnotationValue);
            Util.checkState((pathValue != null ? 1 : 0) != 0, (String)"value was empty on method %s", (Object[])new Object[]{method.getName()});
            if (!methodAnnotationValue.startsWith("/") && !data.template().toString().endsWith("/")) {
                methodAnnotationValue = "/" + methodAnnotationValue;
            }
            data.template().append((CharSequence)methodAnnotationValue);
            this.checkAtMostOne(method, mapping.produces(), "produces");
            String[] serverProduces = mapping.produces();
            String string = clientAccepts = serverProduces.length == 0 ? null : Util.emptyToNull((String)serverProduces[0]);
            if (clientAccepts != null) {
                data.template().header(ACCEPT, new String[]{clientAccepts});
            }
            this.checkAtMostOne(method, mapping.consumes(), "consumes");
            String[] serverConsumes = mapping.consumes();
            String string2 = clientProduces = serverConsumes.length == 0 ? null : Util.emptyToNull((String)serverConsumes[0]);
            if (clientProduces != null) {
                data.template().header(CONTENT_TYPE, new String[]{clientProduces});
            }
            if (mapping.headers() != null && mapping.headers().length > 0) {
                String[] stringArray = mapping.headers();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String header = stringArray[n2];
                    int colon = header.indexOf(58);
                    data.template().header(header.substring(0, colon), new String[]{header.substring(colon + 2)});
                    ++n2;
                }
            }
        }
    }

    private void checkAtMostOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && (values.length == 0 || values.length == 1) ? 1 : 0) != 0, (String)"Method %s can only contain at most 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    private void checkOne(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && values.length == 1 ? 1 : 0) != 0, (String)"Method %s can only contain 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        boolean isHttpAnnotation = false;
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Annotation parameterAnnotation = annotationArray[n2];
            Class<? extends Annotation> annotationType = parameterAnnotation.annotationType();
            if (annotationType == PathVariable.class) {
                name = ((PathVariable)PathVariable.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"PathVariable annotation was empty on param %s.", (Object[])new Object[]{paramIndex});
                this.nameParam(data, name, paramIndex);
                isHttpAnnotation = true;
                String varName = String.valueOf('{') + name + '}';
                if (data.template().url().indexOf(varName) == -1 && !this.searchMapValues(data.template().queries(), varName) && !this.searchMapValues(data.template().headers(), varName)) {
                    data.formParams().add(name);
                }
            } else if (annotationType == RequestParam.class) {
                name = ((RequestParam)RequestParam.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"QueryParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
                Collection query = this.addTemplatedParam((Collection)data.template().queries().get(name), name);
                data.template().query(name, (Iterable)query);
                this.nameParam(data, name, paramIndex);
                isHttpAnnotation = true;
            } else if (annotationType == RequestHeader.class) {
                name = ((RequestHeader)RequestHeader.class.cast(parameterAnnotation)).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"HeaderParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
                Collection header = this.addTemplatedParam((Collection)data.template().headers().get(name), name);
                data.template().header(name, (Iterable)header);
                this.nameParam(data, name, paramIndex);
                isHttpAnnotation = true;
            }
            ++n2;
        }
        return isHttpAnnotation;
    }

    private <K, V> boolean searchMapValues(Map<K, Collection<V>> map, V search) {
        Collection<Collection<V>> values = map.values();
        if (values == null) {
            return false;
        }
        for (Collection<V> entry : values) {
            if (!entry.contains(search)) continue;
            return true;
        }
        return false;
    }
}

