/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DeploymentContext;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAffinityServerListFilter;
import java.util.ArrayList;
import java.util.List;

public class ZonePreferenceServerListFilter
extends ZoneAffinityServerListFilter<Server> {
    private String zone;

    public void initWithNiwsConfig(IClientConfig niwsClientConfig) {
        super.initWithNiwsConfig(niwsClientConfig);
        if (ConfigurationManager.getDeploymentContext() != null) {
            this.zone = ConfigurationManager.getDeploymentContext().getValue(DeploymentContext.ContextKey.zone);
        }
    }

    public List<Server> getFilteredListOfServers(List<Server> servers) {
        List output = super.getFilteredListOfServers(servers);
        if (this.zone != null && output.size() == servers.size()) {
            ArrayList<Server> local = new ArrayList<Server>();
            for (Server server : output) {
                if (!this.zone.equalsIgnoreCase(server.getZone())) continue;
                local.add(server);
            }
            if (!local.isEmpty()) {
                return local;
            }
        }
        return output;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String toString() {
        return "ZonePreferenceServerListFilter(zone=" + this.getZone() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZonePreferenceServerListFilter)) {
            return false;
        }
        ZonePreferenceServerListFilter other = (ZonePreferenceServerListFilter)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$zone = this.getZone();
        String other$zone = other.getZone();
        return !(this$zone == null ? other$zone != null : !this$zone.equals(other$zone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZonePreferenceServerListFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $zone = this.getZone();
        result = result * 59 + ($zone == null ? 0 : $zone.hashCode());
        return result;
    }
}

